// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an Amazon Inspector agent. This data type is used as a request parameter in the ListAssessmentRunAgents action.
 */
public class AgentFilter private constructor(builder: Builder) {
    /**
     * The detailed health state of the agent. Values can be set to **IDLE**, **RUNNING**, **SHUTDOWN**, **UNHEALTHY**, **THROTTLED**, and **UNKNOWN**.
     */
    public val agentHealthCodes: List<AgentHealthCode> = requireNotNull(builder.agentHealthCodes) { "A non-null value must be provided for agentHealthCodes" }
    /**
     * The current health state of the agent. Values can be set to **HEALTHY** or **UNHEALTHY**.
     */
    public val agentHealths: List<AgentHealth> = requireNotNull(builder.agentHealths) { "A non-null value must be provided for agentHealths" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AgentFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentFilter(")
        append("agentHealthCodes=$agentHealthCodes,")
        append("agentHealths=$agentHealths")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentHealthCodes.hashCode()
        result = 31 * result + (agentHealths.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentFilter

        if (agentHealthCodes != other.agentHealthCodes) return false
        if (agentHealths != other.agentHealths) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AgentFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The detailed health state of the agent. Values can be set to **IDLE**, **RUNNING**, **SHUTDOWN**, **UNHEALTHY**, **THROTTLED**, and **UNKNOWN**.
         */
        public var agentHealthCodes: List<AgentHealthCode>? = null
        /**
         * The current health state of the agent. Values can be set to **HEALTHY** or **UNHEALTHY**.
         */
        public var agentHealths: List<AgentHealth>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AgentFilter) : this() {
            this.agentHealthCodes = x.agentHealthCodes
            this.agentHealths = x.agentHealths
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AgentFilter = AgentFilter(this)

        internal fun correctErrors(): Builder {
            if (agentHealthCodes == null) agentHealthCodes = emptyList()
            if (agentHealths == null) agentHealths = emptyList()
            return this
        }
    }
}
