// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.serde

import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentRunResponse
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteAssessmentRunOperationDeserializer: HttpDeserializer.NonStreaming<DeleteAssessmentRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteAssessmentRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteAssessmentRunError(context, call, payload)
        }
        val builder = DeleteAssessmentRunResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteAssessmentRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AssessmentRunInProgressException" -> AssessmentRunInProgressExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceTemporarilyUnavailableException" -> ServiceTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
