// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Used as one of the elements of the AssessmentRun data type.
 */
public class AssessmentRunNotification private constructor(builder: Builder) {
    /**
     * The date of the notification.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.date) { "A non-null value must be provided for date" }
    /**
     * The Boolean value that specifies whether the notification represents an error.
     */
    public val error: kotlin.Boolean = requireNotNull(builder.error) { "A non-null value must be provided for error" }
    /**
     * The event for which a notification is sent.
     */
    public val event: aws.sdk.kotlin.services.inspector.model.InspectorEvent = requireNotNull(builder.event) { "A non-null value must be provided for event" }
    /**
     * The message included in the notification.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status code of the SNS notification.
     */
    public val snsPublishStatusCode: aws.sdk.kotlin.services.inspector.model.AssessmentRunNotificationSnsStatusCode? = builder.snsPublishStatusCode
    /**
     * The SNS topic to which the SNS notification is sent.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentRunNotification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentRunNotification(")
        append("date=$date,")
        append("error=$error,")
        append("event=$event,")
        append("message=$message,")
        append("snsPublishStatusCode=$snsPublishStatusCode,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = date.hashCode()
        result = 31 * result + (error.hashCode())
        result = 31 * result + (event.hashCode())
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (snsPublishStatusCode?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentRunNotification

        if (date != other.date) return false
        if (error != other.error) return false
        if (event != other.event) return false
        if (message != other.message) return false
        if (snsPublishStatusCode != other.snsPublishStatusCode) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentRunNotification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date of the notification.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Boolean value that specifies whether the notification represents an error.
         */
        public var error: kotlin.Boolean? = null
        /**
         * The event for which a notification is sent.
         */
        public var event: aws.sdk.kotlin.services.inspector.model.InspectorEvent? = null
        /**
         * The message included in the notification.
         */
        public var message: kotlin.String? = null
        /**
         * The status code of the SNS notification.
         */
        public var snsPublishStatusCode: aws.sdk.kotlin.services.inspector.model.AssessmentRunNotificationSnsStatusCode? = null
        /**
         * The SNS topic to which the SNS notification is sent.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentRunNotification) : this() {
            this.date = x.date
            this.error = x.error
            this.event = x.event
            this.message = x.message
            this.snsPublishStatusCode = x.snsPublishStatusCode
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentRunNotification = AssessmentRunNotification(this)

        internal fun correctErrors(): Builder {
            if (date == null) date = Instant.fromEpochSeconds(0)
            if (error == null) error = false
            if (event == null) event = InspectorEvent.SdkUnknown("no value provided")
            return this
        }
    }
}
