// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.serde

import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.sdk.kotlin.services.inspector.model.UnsubscribeFromEventResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UnsubscribeFromEventOperationDeserializer: HttpDeserialize<UnsubscribeFromEventResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UnsubscribeFromEventResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUnsubscribeFromEventError(context, call)
        }
        val builder = UnsubscribeFromEventResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUnsubscribeFromEventError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceTemporarilyUnavailableException" -> ServiceTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
