// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.serde

import aws.sdk.kotlin.services.inspector.model.DescribeExclusionsResponse
import aws.sdk.kotlin.services.inspector.model.Exclusion
import aws.sdk.kotlin.services.inspector.model.FailedItemDetails
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class DescribeExclusionsOperationDeserializer: HttpDeserialize<DescribeExclusionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeExclusionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExclusionsError(context, call)
        }
        val builder = DescribeExclusionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExclusionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeExclusionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExclusionsOperationBody(builder: DescribeExclusionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXCLUSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("exclusions"))
    val FAILEDITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("failedItems"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXCLUSIONS_DESCRIPTOR)
        field(FAILEDITEMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXCLUSIONS_DESCRIPTOR.index -> builder.exclusions =
                    deserializer.deserializeMap(EXCLUSIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Exclusion>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeExclusionDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                FAILEDITEMS_DESCRIPTOR.index -> builder.failedItems =
                    deserializer.deserializeMap(FAILEDITEMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FailedItemDetails>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFailedItemDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
