// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model



/**
 * Contains information about the network interfaces interacting with an EC2 instance. This data type is used as one of the elements of the AssetAttributes data type.
 */
public class NetworkInterface private constructor(builder: Builder) {
    /**
     * The IP addresses associated with the network interface.
     */
    public val ipv6Addresses: List<String>? = builder.ipv6Addresses
    /**
     * The ID of the network interface.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The name of a private DNS associated with the network interface.
     */
    public val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The private IP address associated with the network interface.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and privateIpAddress.
     */
    public val privateIpAddresses: List<PrivateIp>? = builder.privateIpAddresses
    /**
     * The name of a public DNS associated with the network interface.
     */
    public val publicDnsName: kotlin.String? = builder.publicDnsName
    /**
     * The public IP address from which the network interface is reachable.
     */
    public val publicIp: kotlin.String? = builder.publicIp
    /**
     * A list of the security groups associated with the network interface. Includes the groupId and groupName.
     */
    public val securityGroups: List<SecurityGroup>? = builder.securityGroups
    /**
     * The ID of a subnet associated with the network interface.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The ID of a VPC associated with the network interface.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.NetworkInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterface(")
        append("ipv6Addresses=$ipv6Addresses,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("publicDnsName=$publicDnsName,")
        append("publicIp=$publicIp,")
        append("securityGroups=$securityGroups,")
        append("subnetId=$subnetId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ipv6Addresses?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInterface

        if (ipv6Addresses != other.ipv6Addresses) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIp != other.publicIp) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetId != other.subnetId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.NetworkInterface = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP addresses associated with the network interface.
         */
        public var ipv6Addresses: List<String>? = null
        /**
         * The ID of the network interface.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The name of a private DNS associated with the network interface.
         */
        public var privateDnsName: kotlin.String? = null
        /**
         * The private IP address associated with the network interface.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and privateIpAddress.
         */
        public var privateIpAddresses: List<PrivateIp>? = null
        /**
         * The name of a public DNS associated with the network interface.
         */
        public var publicDnsName: kotlin.String? = null
        /**
         * The public IP address from which the network interface is reachable.
         */
        public var publicIp: kotlin.String? = null
        /**
         * A list of the security groups associated with the network interface. Includes the groupId and groupName.
         */
        public var securityGroups: List<SecurityGroup>? = null
        /**
         * The ID of a subnet associated with the network interface.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The ID of a VPC associated with the network interface.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.NetworkInterface) : this() {
            this.ipv6Addresses = x.ipv6Addresses
            this.networkInterfaceId = x.networkInterfaceId
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.publicDnsName = x.publicDnsName
            this.publicIp = x.publicIp
            this.securityGroups = x.securityGroups
            this.subnetId = x.subnetId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.NetworkInterface = NetworkInterface(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
