// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an Amazon Inspector finding. This data type is used as the response element in the DescribeFindings action.
 */
public class Finding private constructor(builder: Builder) {
    /**
     * The ARN that specifies the finding.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A collection of attributes of the host from which the finding is generated.
     */
    public val assetAttributes: aws.sdk.kotlin.services.inspector.model.AssetAttributes? = builder.assetAttributes
    /**
     * The type of the host from which the finding is generated.
     */
    public val assetType: aws.sdk.kotlin.services.inspector.model.AssetType? = builder.assetType
    /**
     * The system-defined attributes for the finding.
     */
    public val attributes: List<Attribute> = requireNotNull(builder.attributes) { "A non-null value must be provided for attributes" }
    /**
     * This data element is currently not used.
     */
    public val confidence: kotlin.Int = builder.confidence
    /**
     * The time when the finding was generated.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the finding.
     */
    public val id: kotlin.String? = builder.id
    /**
     * This data element is currently not used.
     */
    public val indicatorOfCompromise: kotlin.Boolean? = builder.indicatorOfCompromise
    /**
     * The numeric value of the finding severity.
     */
    public val numericSeverity: kotlin.Double = builder.numericSeverity
    /**
     * The recommendation for the finding.
     */
    public val recommendation: kotlin.String? = builder.recommendation
    /**
     * The schema version of this data type.
     */
    public val schemaVersion: kotlin.Int = builder.schemaVersion
    /**
     * The data element is set to "Inspector".
     */
    public val service: kotlin.String? = builder.service
    /**
     * This data type is used in the Finding data type.
     */
    public val serviceAttributes: aws.sdk.kotlin.services.inspector.model.InspectorServiceAttributes? = builder.serviceAttributes
    /**
     * The finding severity. Values can be set to High, Medium, Low, and Informational.
     */
    public val severity: aws.sdk.kotlin.services.inspector.model.Severity? = builder.severity
    /**
     * The name of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The time when AddAttributesToFindings is called.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The user-defined attributes that are assigned to the finding.
     */
    public val userAttributes: List<Attribute> = requireNotNull(builder.userAttributes) { "A non-null value must be provided for userAttributes" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.Finding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("arn=$arn,")
        append("assetAttributes=$assetAttributes,")
        append("assetType=$assetType,")
        append("attributes=$attributes,")
        append("confidence=$confidence,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("id=$id,")
        append("indicatorOfCompromise=$indicatorOfCompromise,")
        append("numericSeverity=$numericSeverity,")
        append("recommendation=$recommendation,")
        append("schemaVersion=$schemaVersion,")
        append("service=$service,")
        append("serviceAttributes=$serviceAttributes,")
        append("severity=$severity,")
        append("title=$title,")
        append("updatedAt=$updatedAt,")
        append("userAttributes=$userAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assetAttributes?.hashCode() ?: 0)
        result = 31 * result + (assetType?.hashCode() ?: 0)
        result = 31 * result + (attributes.hashCode())
        result = 31 * result + (confidence)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indicatorOfCompromise?.hashCode() ?: 0)
        result = 31 * result + (numericSeverity.hashCode())
        result = 31 * result + (recommendation?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (serviceAttributes?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (userAttributes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Finding

        if (arn != other.arn) return false
        if (assetAttributes != other.assetAttributes) return false
        if (assetType != other.assetType) return false
        if (attributes != other.attributes) return false
        if (confidence != other.confidence) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (indicatorOfCompromise != other.indicatorOfCompromise) return false
        if (numericSeverity != other.numericSeverity) return false
        if (recommendation != other.recommendation) return false
        if (schemaVersion != other.schemaVersion) return false
        if (service != other.service) return false
        if (serviceAttributes != other.serviceAttributes) return false
        if (severity != other.severity) return false
        if (title != other.title) return false
        if (updatedAt != other.updatedAt) return false
        if (userAttributes != other.userAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.Finding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN that specifies the finding.
         */
        public var arn: kotlin.String? = null
        /**
         * A collection of attributes of the host from which the finding is generated.
         */
        public var assetAttributes: aws.sdk.kotlin.services.inspector.model.AssetAttributes? = null
        /**
         * The type of the host from which the finding is generated.
         */
        public var assetType: aws.sdk.kotlin.services.inspector.model.AssetType? = null
        /**
         * The system-defined attributes for the finding.
         */
        public var attributes: List<Attribute>? = null
        /**
         * This data element is currently not used.
         */
        public var confidence: kotlin.Int = 0
        /**
         * The time when the finding was generated.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the finding.
         */
        public var id: kotlin.String? = null
        /**
         * This data element is currently not used.
         */
        public var indicatorOfCompromise: kotlin.Boolean? = null
        /**
         * The numeric value of the finding severity.
         */
        public var numericSeverity: kotlin.Double = 0.0
        /**
         * The recommendation for the finding.
         */
        public var recommendation: kotlin.String? = null
        /**
         * The schema version of this data type.
         */
        public var schemaVersion: kotlin.Int = 0
        /**
         * The data element is set to "Inspector".
         */
        public var service: kotlin.String? = null
        /**
         * This data type is used in the Finding data type.
         */
        public var serviceAttributes: aws.sdk.kotlin.services.inspector.model.InspectorServiceAttributes? = null
        /**
         * The finding severity. Values can be set to High, Medium, Low, and Informational.
         */
        public var severity: aws.sdk.kotlin.services.inspector.model.Severity? = null
        /**
         * The name of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The time when AddAttributesToFindings is called.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-defined attributes that are assigned to the finding.
         */
        public var userAttributes: List<Attribute>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.Finding) : this() {
            this.arn = x.arn
            this.assetAttributes = x.assetAttributes
            this.assetType = x.assetType
            this.attributes = x.attributes
            this.confidence = x.confidence
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.indicatorOfCompromise = x.indicatorOfCompromise
            this.numericSeverity = x.numericSeverity
            this.recommendation = x.recommendation
            this.schemaVersion = x.schemaVersion
            this.service = x.service
            this.serviceAttributes = x.serviceAttributes
            this.severity = x.severity
            this.title = x.title
            this.updatedAt = x.updatedAt
            this.userAttributes = x.userAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.Finding = Finding(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector.model.AssetAttributes] inside the given [block]
         */
        public fun assetAttributes(block: aws.sdk.kotlin.services.inspector.model.AssetAttributes.Builder.() -> kotlin.Unit) {
            this.assetAttributes = aws.sdk.kotlin.services.inspector.model.AssetAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector.model.InspectorServiceAttributes] inside the given [block]
         */
        public fun serviceAttributes(block: aws.sdk.kotlin.services.inspector.model.InspectorServiceAttributes.Builder.() -> kotlin.Unit) {
            this.serviceAttributes = aws.sdk.kotlin.services.inspector.model.InspectorServiceAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (attributes == null) attributes = emptyList()
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (userAttributes == null) userAttributes = emptyList()
            return this
        }
    }
}
