// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model



/**
 * A collection of attributes of the host from which the finding is generated.
 */
public class AssetAttributes private constructor(builder: Builder) {
    /**
     * The ID of the agent that is installed on the EC2 instance where the finding is generated.
     */
    public val agentId: kotlin.String? = builder.agentId
    /**
     * The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is generated.
     */
    public val amiId: kotlin.String? = builder.amiId
    /**
     * The Auto Scaling group of the EC2 instance where the finding is generated.
     */
    public val autoScalingGroup: kotlin.String? = builder.autoScalingGroup
    /**
     * The hostname of the EC2 instance where the finding is generated.
     */
    public val hostname: kotlin.String? = builder.hostname
    /**
     * The list of IP v4 addresses of the EC2 instance where the finding is generated.
     */
    public val ipv4Addresses: List<String>? = builder.ipv4Addresses
    /**
     * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
     */
    public val networkInterfaces: List<NetworkInterface>? = builder.networkInterfaces
    /**
     * The schema version of this data type.
     */
    public val schemaVersion: kotlin.Int = builder.schemaVersion
    /**
     * The tags related to the EC2 instance where the finding is generated.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssetAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetAttributes(")
        append("agentId=$agentId,")
        append("amiId=$amiId,")
        append("autoScalingGroup=$autoScalingGroup,")
        append("hostname=$hostname,")
        append("ipv4Addresses=$ipv4Addresses,")
        append("networkInterfaces=$networkInterfaces,")
        append("schemaVersion=$schemaVersion,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId?.hashCode() ?: 0
        result = 31 * result + (amiId?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroup?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (ipv4Addresses?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetAttributes

        if (agentId != other.agentId) return false
        if (amiId != other.amiId) return false
        if (autoScalingGroup != other.autoScalingGroup) return false
        if (hostname != other.hostname) return false
        if (ipv4Addresses != other.ipv4Addresses) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (schemaVersion != other.schemaVersion) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssetAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the agent that is installed on the EC2 instance where the finding is generated.
         */
        public var agentId: kotlin.String? = null
        /**
         * The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is generated.
         */
        public var amiId: kotlin.String? = null
        /**
         * The Auto Scaling group of the EC2 instance where the finding is generated.
         */
        public var autoScalingGroup: kotlin.String? = null
        /**
         * The hostname of the EC2 instance where the finding is generated.
         */
        public var hostname: kotlin.String? = null
        /**
         * The list of IP v4 addresses of the EC2 instance where the finding is generated.
         */
        public var ipv4Addresses: List<String>? = null
        /**
         * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         */
        public var networkInterfaces: List<NetworkInterface>? = null
        /**
         * The schema version of this data type.
         */
        public var schemaVersion: kotlin.Int = 0
        /**
         * The tags related to the EC2 instance where the finding is generated.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssetAttributes) : this() {
            this.agentId = x.agentId
            this.amiId = x.amiId
            this.autoScalingGroup = x.autoScalingGroup
            this.hostname = x.hostname
            this.ipv4Addresses = x.ipv4Addresses
            this.networkInterfaces = x.networkInterfaces
            this.schemaVersion = x.schemaVersion
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssetAttributes = AssetAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
