// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an Amazon Inspector application. This data type is used as the response element in the DescribeAssessmentTargets action.
 */
public class AssessmentTarget private constructor(builder: Builder) {
    /**
     * The ARN that specifies the Amazon Inspector assessment target.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The time at which the assessment target is created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The name of the Amazon Inspector assessment target.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The ARN that specifies the resource group that is associated with the assessment target.
     */
    public val resourceGroupArn: kotlin.String? = builder.resourceGroupArn
    /**
     * The time at which UpdateAssessmentTarget is called.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentTarget(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("name=$name,")
        append("resourceGroupArn=$resourceGroupArn,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (resourceGroupArn?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentTarget

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (name != other.name) return false
        if (resourceGroupArn != other.resourceGroupArn) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN that specifies the Amazon Inspector assessment target.
         */
        public var arn: kotlin.String? = null
        /**
         * The time at which the assessment target is created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Inspector assessment target.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN that specifies the resource group that is associated with the assessment target.
         */
        public var resourceGroupArn: kotlin.String? = null
        /**
         * The time at which UpdateAssessmentTarget is called.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentTarget) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.name = x.name
            this.resourceGroupArn = x.resourceGroupArn
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentTarget = AssessmentTarget(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
