// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * You cannot perform a specified action if an assessment run is currently in progress.
 */
public class AssessmentRunInProgressException private constructor(builder: Builder) : InspectorException() {

    /**
     * The ARNs of the assessment runs that are currently in progress.
     */
    public val assessmentRunArns: List<String> = requireNotNull(builder.assessmentRunArns) { "A non-null value must be provided for assessmentRunArns" }
    /**
     * Boolean value that indicates whether the ARN list of the assessment runs is truncated.
     */
    public val assessmentRunArnsTruncated: kotlin.Boolean = requireNotNull(builder.assessmentRunArnsTruncated) { "A non-null value must be provided for assessmentRunArnsTruncated" }
    /**
     * You can immediately retry your request.
     */
    public val canRetry: kotlin.Boolean = requireNotNull(builder.canRetry) { "A non-null value must be provided for canRetry" }
    /**
     * Details of the exception error.
     */
    override val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentRunInProgressException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentRunInProgressException(")
        append("assessmentRunArns=$assessmentRunArns,")
        append("assessmentRunArnsTruncated=$assessmentRunArnsTruncated,")
        append("canRetry=$canRetry,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentRunArns.hashCode()
        result = 31 * result + (assessmentRunArnsTruncated.hashCode())
        result = 31 * result + (canRetry.hashCode())
        result = 31 * result + (message.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentRunInProgressException

        if (assessmentRunArns != other.assessmentRunArns) return false
        if (assessmentRunArnsTruncated != other.assessmentRunArnsTruncated) return false
        if (canRetry != other.canRetry) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentRunInProgressException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARNs of the assessment runs that are currently in progress.
         */
        public var assessmentRunArns: List<String>? = null
        /**
         * Boolean value that indicates whether the ARN list of the assessment runs is truncated.
         */
        public var assessmentRunArnsTruncated: kotlin.Boolean? = null
        /**
         * You can immediately retry your request.
         */
        public var canRetry: kotlin.Boolean? = null
        /**
         * Details of the exception error.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentRunInProgressException) : this() {
            this.assessmentRunArns = x.assessmentRunArns
            this.assessmentRunArnsTruncated = x.assessmentRunArnsTruncated
            this.canRetry = x.canRetry
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentRunInProgressException = AssessmentRunInProgressException(this)

        internal fun correctErrors(): Builder {
            if (assessmentRunArns == null) assessmentRunArns = emptyList()
            if (assessmentRunArnsTruncated == null) assessmentRunArnsTruncated = false
            if (canRetry == null) canRetry = false
            if (message == null) message = ""
            return this
        }
    }
}
