// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A snapshot of an Amazon Inspector assessment run that contains the findings of the assessment run .
 *
 * Used as the response element in the DescribeAssessmentRuns action.
 */
public class AssessmentRun private constructor(builder: Builder) {
    /**
     * The ARN of the assessment run.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The ARN of the assessment template that is associated with the assessment run.
     */
    public val assessmentTemplateArn: kotlin.String = requireNotNull(builder.assessmentTemplateArn) { "A non-null value must be provided for assessmentTemplateArn" }
    /**
     * The assessment run completion time that corresponds to the rules packages evaluation completion time or failure.
     */
    public val completedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.completedAt
    /**
     * The time when StartAssessmentRun was called.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * A Boolean value (true or false) that specifies whether the process of collecting data from the agents is completed.
     */
    public val dataCollected: kotlin.Boolean = requireNotNull(builder.dataCollected) { "A non-null value must be provided for dataCollected" }
    /**
     * The duration of the assessment run.
     */
    public val durationInSeconds: kotlin.Int = requireNotNull(builder.durationInSeconds) { "A non-null value must be provided for durationInSeconds" }
    /**
     * Provides a total count of generated findings per severity.
     */
    public val findingCounts: Map<String, Int> = requireNotNull(builder.findingCounts) { "A non-null value must be provided for findingCounts" }
    /**
     * The auto-generated name for the assessment run.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A list of notifications for the event subscriptions. A notification about a particular generated finding is added to this list only once.
     */
    public val notifications: List<AssessmentRunNotification> = requireNotNull(builder.notifications) { "A non-null value must be provided for notifications" }
    /**
     * The rules packages selected for the assessment run.
     */
    public val rulesPackageArns: List<String> = requireNotNull(builder.rulesPackageArns) { "A non-null value must be provided for rulesPackageArns" }
    /**
     * The time when StartAssessmentRun was called.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The state of the assessment run.
     */
    public val state: aws.sdk.kotlin.services.inspector.model.AssessmentRunState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The last time when the assessment run's state changed.
     */
    public val stateChangedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.stateChangedAt) { "A non-null value must be provided for stateChangedAt" }
    /**
     * A list of the assessment run state changes.
     */
    public val stateChanges: List<AssessmentRunStateChange> = requireNotNull(builder.stateChanges) { "A non-null value must be provided for stateChanges" }
    /**
     * The user-defined attributes that are assigned to every generated finding.
     */
    public val userAttributesForFindings: List<Attribute> = requireNotNull(builder.userAttributesForFindings) { "A non-null value must be provided for userAttributesForFindings" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentRun = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentRun(")
        append("arn=$arn,")
        append("assessmentTemplateArn=$assessmentTemplateArn,")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("dataCollected=$dataCollected,")
        append("durationInSeconds=$durationInSeconds,")
        append("findingCounts=$findingCounts,")
        append("name=$name,")
        append("notifications=$notifications,")
        append("rulesPackageArns=$rulesPackageArns,")
        append("startedAt=$startedAt,")
        append("state=$state,")
        append("stateChangedAt=$stateChangedAt,")
        append("stateChanges=$stateChanges,")
        append("userAttributesForFindings=$userAttributesForFindings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assessmentTemplateArn.hashCode())
        result = 31 * result + (completedAt?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (dataCollected.hashCode())
        result = 31 * result + (durationInSeconds)
        result = 31 * result + (findingCounts.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (notifications.hashCode())
        result = 31 * result + (rulesPackageArns.hashCode())
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (stateChangedAt.hashCode())
        result = 31 * result + (stateChanges.hashCode())
        result = 31 * result + (userAttributesForFindings.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentRun

        if (arn != other.arn) return false
        if (assessmentTemplateArn != other.assessmentTemplateArn) return false
        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (dataCollected != other.dataCollected) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (findingCounts != other.findingCounts) return false
        if (name != other.name) return false
        if (notifications != other.notifications) return false
        if (rulesPackageArns != other.rulesPackageArns) return false
        if (startedAt != other.startedAt) return false
        if (state != other.state) return false
        if (stateChangedAt != other.stateChangedAt) return false
        if (stateChanges != other.stateChanges) return false
        if (userAttributesForFindings != other.userAttributesForFindings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentRun = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the assessment run.
         */
        public var arn: kotlin.String? = null
        /**
         * The ARN of the assessment template that is associated with the assessment run.
         */
        public var assessmentTemplateArn: kotlin.String? = null
        /**
         * The assessment run completion time that corresponds to the rules packages evaluation completion time or failure.
         */
        public var completedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when StartAssessmentRun was called.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A Boolean value (true or false) that specifies whether the process of collecting data from the agents is completed.
         */
        public var dataCollected: kotlin.Boolean? = null
        /**
         * The duration of the assessment run.
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * Provides a total count of generated findings per severity.
         */
        public var findingCounts: Map<String, Int>? = null
        /**
         * The auto-generated name for the assessment run.
         */
        public var name: kotlin.String? = null
        /**
         * A list of notifications for the event subscriptions. A notification about a particular generated finding is added to this list only once.
         */
        public var notifications: List<AssessmentRunNotification>? = null
        /**
         * The rules packages selected for the assessment run.
         */
        public var rulesPackageArns: List<String>? = null
        /**
         * The time when StartAssessmentRun was called.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the assessment run.
         */
        public var state: aws.sdk.kotlin.services.inspector.model.AssessmentRunState? = null
        /**
         * The last time when the assessment run's state changed.
         */
        public var stateChangedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of the assessment run state changes.
         */
        public var stateChanges: List<AssessmentRunStateChange>? = null
        /**
         * The user-defined attributes that are assigned to every generated finding.
         */
        public var userAttributesForFindings: List<Attribute>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentRun) : this() {
            this.arn = x.arn
            this.assessmentTemplateArn = x.assessmentTemplateArn
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.dataCollected = x.dataCollected
            this.durationInSeconds = x.durationInSeconds
            this.findingCounts = x.findingCounts
            this.name = x.name
            this.notifications = x.notifications
            this.rulesPackageArns = x.rulesPackageArns
            this.startedAt = x.startedAt
            this.state = x.state
            this.stateChangedAt = x.stateChangedAt
            this.stateChanges = x.stateChanges
            this.userAttributesForFindings = x.userAttributesForFindings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentRun = AssessmentRun(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (assessmentTemplateArn == null) assessmentTemplateArn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (dataCollected == null) dataCollected = false
            if (durationInSeconds == null) durationInSeconds = 0
            if (findingCounts == null) findingCounts = emptyMap()
            if (name == null) name = ""
            if (notifications == null) notifications = emptyList()
            if (rulesPackageArns == null) rulesPackageArns = emptyList()
            if (state == null) state = AssessmentRunState.SdkUnknown("no value provided")
            if (stateChangedAt == null) stateChangedAt = Instant.fromEpochSeconds(0)
            if (stateChanges == null) stateChanges = emptyList()
            if (userAttributesForFindings == null) userAttributesForFindings = emptyList()
            return this
        }
    }
}
