// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.services.inspector.model.ExclusionPreview
import aws.sdk.kotlin.services.inspector.model.GetExclusionsPreviewResponse
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.sdk.kotlin.services.inspector.model.PreviewStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetExclusionsPreviewOperationDeserializer: HttpDeserialize<GetExclusionsPreviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetExclusionsPreviewResponse {
        if (!response.status.isSuccess()) {
            throwGetExclusionsPreviewError(context, response)
        }
        val builder = GetExclusionsPreviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetExclusionsPreviewOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetExclusionsPreviewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetExclusionsPreviewOperationBody(builder: GetExclusionsPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXCLUSIONPREVIEWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("exclusionPreviews"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PREVIEWSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("previewStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXCLUSIONPREVIEWS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PREVIEWSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXCLUSIONPREVIEWS_DESCRIPTOR.index -> builder.exclusionPreviews =
                    deserializer.deserializeList(EXCLUSIONPREVIEWS_DESCRIPTOR) {
                        val col0 = mutableListOf<ExclusionPreview>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeExclusionPreviewDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PREVIEWSTATUS_DESCRIPTOR.index -> builder.previewStatus = deserializeString().let { PreviewStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
