// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.services.inspector.model.DescribeFindingsResponse
import aws.sdk.kotlin.services.inspector.model.FailedItemDetails
import aws.sdk.kotlin.services.inspector.model.Finding
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeFindingsOperationDeserializer: HttpDeserialize<DescribeFindingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFindingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFindingsError(context, response)
        }
        val builder = DescribeFindingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFindingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFindingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFindingsOperationBody(builder: DescribeFindingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("failedItems"))
    val FINDINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("findings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDITEMS_DESCRIPTOR)
        field(FINDINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDITEMS_DESCRIPTOR.index -> builder.failedItems =
                    deserializer.deserializeMap(FAILEDITEMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FailedItemDetails>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFailedItemDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                FINDINGS_DESCRIPTOR.index -> builder.findings =
                    deserializer.deserializeList(FINDINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Finding>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFindingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
