// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.services.inspector.model.CreateExclusionsPreviewResponse
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateExclusionsPreviewOperationDeserializer: HttpDeserialize<CreateExclusionsPreviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateExclusionsPreviewResponse {
        if (!response.status.isSuccess()) {
            throwCreateExclusionsPreviewError(context, response)
        }
        val builder = CreateExclusionsPreviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateExclusionsPreviewOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateExclusionsPreviewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreviewGenerationInProgressException" -> PreviewGenerationInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceTemporarilyUnavailableException" -> ServiceTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateExclusionsPreviewOperationBody(builder: CreateExclusionsPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PREVIEWTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("previewToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PREVIEWTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PREVIEWTOKEN_DESCRIPTOR.index -> builder.previewToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
