// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.services.inspector.model.CreateAssessmentTemplateResponse
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAssessmentTemplateOperationDeserializer: HttpDeserialize<CreateAssessmentTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateAssessmentTemplateResponse {
        if (!response.status.isSuccess()) {
            throwCreateAssessmentTemplateError(context, response)
        }
        val builder = CreateAssessmentTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAssessmentTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateAssessmentTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceTemporarilyUnavailableException" -> ServiceTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAssessmentTemplateOperationBody(builder: CreateAssessmentTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSESSMENTTEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assessmentTemplateArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSESSMENTTEMPLATEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSESSMENTTEMPLATEARN_DESCRIPTOR.index -> builder.assessmentTemplateArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
