// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.inspector.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.inspector.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.inspector.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.inspector.model.*
import aws.sdk.kotlin.services.inspector.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Inspector"
public const val ServiceApiVersion: String = "2016-02-16"
public const val SdkVersion: String = "0.24.0-beta"

internal class DefaultInspectorClient(override val config: InspectorClient.Config) : InspectorClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "inspector")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     */
    override suspend fun addAttributesToFindings(input: AddAttributesToFindingsRequest): AddAttributesToFindingsResponse {
        val op = SdkHttpOperation.build<AddAttributesToFindingsRequest, AddAttributesToFindingsResponse> {
            serializer = AddAttributesToFindingsOperationSerializer()
            deserializer = AddAttributesToFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AddAttributesToFindings"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddAttributesToFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see [ Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     */
    override suspend fun createAssessmentTarget(input: CreateAssessmentTargetRequest): CreateAssessmentTargetResponse {
        val op = SdkHttpOperation.build<CreateAssessmentTargetRequest, CreateAssessmentTargetResponse> {
            serializer = CreateAssessmentTargetOperationSerializer()
            deserializer = CreateAssessmentTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateAssessmentTarget"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAssessmentTarget-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.
     */
    override suspend fun createAssessmentTemplate(input: CreateAssessmentTemplateRequest): CreateAssessmentTemplateResponse {
        val op = SdkHttpOperation.build<CreateAssessmentTemplateRequest, CreateAssessmentTemplateResponse> {
            serializer = CreateAssessmentTemplateOperationSerializer()
            deserializer = CreateAssessmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateAssessmentTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAssessmentTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     */
    override suspend fun createExclusionsPreview(input: CreateExclusionsPreviewRequest): CreateExclusionsPreviewResponse {
        val op = SdkHttpOperation.build<CreateExclusionsPreviewRequest, CreateExclusionsPreviewResponse> {
            serializer = CreateExclusionsPreviewOperationSerializer()
            deserializer = CreateExclusionsPreviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateExclusionsPreview"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateExclusionsPreview-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see CreateAssessmentTarget.
     */
    override suspend fun createResourceGroup(input: CreateResourceGroupRequest): CreateResourceGroupResponse {
        val op = SdkHttpOperation.build<CreateResourceGroupRequest, CreateResourceGroupResponse> {
            serializer = CreateResourceGroupOperationSerializer()
            deserializer = CreateResourceGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateResourceGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateResourceGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     */
    override suspend fun deleteAssessmentRun(input: DeleteAssessmentRunRequest): DeleteAssessmentRunResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentRunRequest, DeleteAssessmentRunResponse> {
            serializer = DeleteAssessmentRunOperationSerializer()
            deserializer = DeleteAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteAssessmentRun"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAssessmentRun-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     */
    override suspend fun deleteAssessmentTarget(input: DeleteAssessmentTargetRequest): DeleteAssessmentTargetResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentTargetRequest, DeleteAssessmentTargetResponse> {
            serializer = DeleteAssessmentTargetOperationSerializer()
            deserializer = DeleteAssessmentTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteAssessmentTarget"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAssessmentTarget-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     */
    override suspend fun deleteAssessmentTemplate(input: DeleteAssessmentTemplateRequest): DeleteAssessmentTemplateResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentTemplateRequest, DeleteAssessmentTemplateResponse> {
            serializer = DeleteAssessmentTemplateOperationSerializer()
            deserializer = DeleteAssessmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteAssessmentTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAssessmentTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     */
    override suspend fun describeAssessmentRuns(input: DescribeAssessmentRunsRequest): DescribeAssessmentRunsResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentRunsRequest, DescribeAssessmentRunsResponse> {
            serializer = DescribeAssessmentRunsOperationSerializer()
            deserializer = DescribeAssessmentRunsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeAssessmentRuns"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAssessmentRuns-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     */
    override suspend fun describeAssessmentTargets(input: DescribeAssessmentTargetsRequest): DescribeAssessmentTargetsResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentTargetsRequest, DescribeAssessmentTargetsResponse> {
            serializer = DescribeAssessmentTargetsOperationSerializer()
            deserializer = DescribeAssessmentTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeAssessmentTargets"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAssessmentTargets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     */
    override suspend fun describeAssessmentTemplates(input: DescribeAssessmentTemplatesRequest): DescribeAssessmentTemplatesResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentTemplatesRequest, DescribeAssessmentTemplatesResponse> {
            serializer = DescribeAssessmentTemplatesOperationSerializer()
            deserializer = DescribeAssessmentTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeAssessmentTemplates"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAssessmentTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     */
    override suspend fun describeCrossAccountAccessRole(input: DescribeCrossAccountAccessRoleRequest): DescribeCrossAccountAccessRoleResponse {
        val op = SdkHttpOperation.build<DescribeCrossAccountAccessRoleRequest, DescribeCrossAccountAccessRoleResponse> {
            serializer = DescribeCrossAccountAccessRoleOperationSerializer()
            deserializer = DescribeCrossAccountAccessRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeCrossAccountAccessRole"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCrossAccountAccessRole-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the exclusions that are specified by the exclusions' ARNs.
     */
    override suspend fun describeExclusions(input: DescribeExclusionsRequest): DescribeExclusionsResponse {
        val op = SdkHttpOperation.build<DescribeExclusionsRequest, DescribeExclusionsResponse> {
            serializer = DescribeExclusionsOperationSerializer()
            deserializer = DescribeExclusionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeExclusions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeExclusions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the findings that are specified by the ARNs of the findings.
     */
    override suspend fun describeFindings(input: DescribeFindingsRequest): DescribeFindingsResponse {
        val op = SdkHttpOperation.build<DescribeFindingsRequest, DescribeFindingsResponse> {
            serializer = DescribeFindingsOperationSerializer()
            deserializer = DescribeFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeFindings"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     */
    override suspend fun describeResourceGroups(input: DescribeResourceGroupsRequest): DescribeResourceGroupsResponse {
        val op = SdkHttpOperation.build<DescribeResourceGroupsRequest, DescribeResourceGroupsResponse> {
            serializer = DescribeResourceGroupsOperationSerializer()
            deserializer = DescribeResourceGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeResourceGroups"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeResourceGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     */
    override suspend fun describeRulesPackages(input: DescribeRulesPackagesRequest): DescribeRulesPackagesResponse {
        val op = SdkHttpOperation.build<DescribeRulesPackagesRequest, DescribeRulesPackagesResponse> {
            serializer = DescribeRulesPackagesOperationSerializer()
            deserializer = DescribeRulesPackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRulesPackages"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRulesPackages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     */
    override suspend fun getAssessmentReport(input: GetAssessmentReportRequest): GetAssessmentReportResponse {
        val op = SdkHttpOperation.build<GetAssessmentReportRequest, GetAssessmentReportResponse> {
            serializer = GetAssessmentReportOperationSerializer()
            deserializer = GetAssessmentReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetAssessmentReport"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetAssessmentReport-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.
     */
    override suspend fun getExclusionsPreview(input: GetExclusionsPreviewRequest): GetExclusionsPreviewResponse {
        val op = SdkHttpOperation.build<GetExclusionsPreviewRequest, GetExclusionsPreviewResponse> {
            serializer = GetExclusionsPreviewOperationSerializer()
            deserializer = GetExclusionsPreviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetExclusionsPreview"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetExclusionsPreview-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Information about the data that is collected for the specified assessment run.
     */
    override suspend fun getTelemetryMetadata(input: GetTelemetryMetadataRequest): GetTelemetryMetadataResponse {
        val op = SdkHttpOperation.build<GetTelemetryMetadataRequest, GetTelemetryMetadataResponse> {
            serializer = GetTelemetryMetadataOperationSerializer()
            deserializer = GetTelemetryMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTelemetryMetadata"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTelemetryMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     */
    override suspend fun listAssessmentRunAgents(input: ListAssessmentRunAgentsRequest): ListAssessmentRunAgentsResponse {
        val op = SdkHttpOperation.build<ListAssessmentRunAgentsRequest, ListAssessmentRunAgentsResponse> {
            serializer = ListAssessmentRunAgentsOperationSerializer()
            deserializer = ListAssessmentRunAgentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAssessmentRunAgents"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAssessmentRunAgents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     */
    override suspend fun listAssessmentRuns(input: ListAssessmentRunsRequest): ListAssessmentRunsResponse {
        val op = SdkHttpOperation.build<ListAssessmentRunsRequest, ListAssessmentRunsResponse> {
            serializer = ListAssessmentRunsOperationSerializer()
            deserializer = ListAssessmentRunsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAssessmentRuns"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAssessmentRuns-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     */
    override suspend fun listAssessmentTargets(input: ListAssessmentTargetsRequest): ListAssessmentTargetsResponse {
        val op = SdkHttpOperation.build<ListAssessmentTargetsRequest, ListAssessmentTargetsResponse> {
            serializer = ListAssessmentTargetsOperationSerializer()
            deserializer = ListAssessmentTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAssessmentTargets"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAssessmentTargets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     */
    override suspend fun listAssessmentTemplates(input: ListAssessmentTemplatesRequest): ListAssessmentTemplatesResponse {
        val op = SdkHttpOperation.build<ListAssessmentTemplatesRequest, ListAssessmentTemplatesResponse> {
            serializer = ListAssessmentTemplatesOperationSerializer()
            deserializer = ListAssessmentTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAssessmentTemplates"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAssessmentTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see SubscribeToEvent and UnsubscribeFromEvent.
     */
    override suspend fun listEventSubscriptions(input: ListEventSubscriptionsRequest): ListEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<ListEventSubscriptionsRequest, ListEventSubscriptionsResponse> {
            serializer = ListEventSubscriptionsOperationSerializer()
            deserializer = ListEventSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEventSubscriptions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEventSubscriptions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List exclusions that are generated by the assessment run.
     */
    override suspend fun listExclusions(input: ListExclusionsRequest): ListExclusionsResponse {
        val op = SdkHttpOperation.build<ListExclusionsRequest, ListExclusionsResponse> {
            serializer = ListExclusionsOperationSerializer()
            deserializer = ListExclusionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListExclusions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListExclusions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializer = ListFindingsOperationSerializer()
            deserializer = ListFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFindings"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all available Amazon Inspector rules packages.
     */
    override suspend fun listRulesPackages(input: ListRulesPackagesRequest): ListRulesPackagesResponse {
        val op = SdkHttpOperation.build<ListRulesPackagesRequest, ListRulesPackagesResponse> {
            serializer = ListRulesPackagesOperationSerializer()
            deserializer = ListRulesPackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListRulesPackages"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRulesPackages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags associated with an assessment template.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTagsForResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     */
    override suspend fun previewAgents(input: PreviewAgentsRequest): PreviewAgentsResponse {
        val op = SdkHttpOperation.build<PreviewAgentsRequest, PreviewAgentsResponse> {
            serializer = PreviewAgentsOperationSerializer()
            deserializer = PreviewAgentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PreviewAgents"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PreviewAgents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.
     */
    override suspend fun registerCrossAccountAccessRole(input: RegisterCrossAccountAccessRoleRequest): RegisterCrossAccountAccessRoleResponse {
        val op = SdkHttpOperation.build<RegisterCrossAccountAccessRoleRequest, RegisterCrossAccountAccessRoleResponse> {
            serializer = RegisterCrossAccountAccessRoleOperationSerializer()
            deserializer = RegisterCrossAccountAccessRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "RegisterCrossAccountAccessRole"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RegisterCrossAccountAccessRole-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     */
    override suspend fun removeAttributesFromFindings(input: RemoveAttributesFromFindingsRequest): RemoveAttributesFromFindingsResponse {
        val op = SdkHttpOperation.build<RemoveAttributesFromFindingsRequest, RemoveAttributesFromFindingsResponse> {
            serializer = RemoveAttributesFromFindingsOperationSerializer()
            deserializer = RemoveAttributesFromFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "RemoveAttributesFromFindings"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveAttributesFromFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     */
    override suspend fun setTagsForResource(input: SetTagsForResourceRequest): SetTagsForResourceResponse {
        val op = SdkHttpOperation.build<SetTagsForResourceRequest, SetTagsForResourceResponse> {
            serializer = SetTagsForResourceOperationSerializer()
            deserializer = SetTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SetTagsForResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SetTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
     */
    override suspend fun startAssessmentRun(input: StartAssessmentRunRequest): StartAssessmentRunResponse {
        val op = SdkHttpOperation.build<StartAssessmentRunRequest, StartAssessmentRunResponse> {
            serializer = StartAssessmentRunOperationSerializer()
            deserializer = StartAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartAssessmentRun"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartAssessmentRun-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     */
    override suspend fun stopAssessmentRun(input: StopAssessmentRunRequest): StopAssessmentRunResponse {
        val op = SdkHttpOperation.build<StopAssessmentRunRequest, StopAssessmentRunResponse> {
            serializer = StopAssessmentRunOperationSerializer()
            deserializer = StopAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopAssessmentRun"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopAssessmentRun-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     */
    override suspend fun subscribeToEvent(input: SubscribeToEventRequest): SubscribeToEventResponse {
        val op = SdkHttpOperation.build<SubscribeToEventRequest, SubscribeToEventResponse> {
            serializer = SubscribeToEventOperationSerializer()
            deserializer = SubscribeToEventOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SubscribeToEvent"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SubscribeToEvent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     */
    override suspend fun unsubscribeFromEvent(input: UnsubscribeFromEventRequest): UnsubscribeFromEventResponse {
        val op = SdkHttpOperation.build<UnsubscribeFromEventRequest, UnsubscribeFromEventResponse> {
            serializer = UnsubscribeFromEventOperationSerializer()
            deserializer = UnsubscribeFromEventOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UnsubscribeFromEvent"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UnsubscribeFromEvent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     */
    override suspend fun updateAssessmentTarget(input: UpdateAssessmentTargetRequest): UpdateAssessmentTargetResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentTargetRequest, UpdateAssessmentTargetResponse> {
            serializer = UpdateAssessmentTargetOperationSerializer()
            deserializer = UpdateAssessmentTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateAssessmentTarget"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAssessmentTarget-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "inspector")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
