// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.sdk.kotlin.services.inspector.model.SetTagsForResourceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class SetTagsForResourceOperationDeserializer: HttpDeserialize<SetTagsForResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SetTagsForResourceResponse {
        if (!response.status.isSuccess()) {
            throwSetTagsForResourceError(context, response)
        }
        val builder = SetTagsForResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwSetTagsForResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntityException" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceTemporarilyUnavailableException" -> ServiceTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
