// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.inspector.model.AssessmentRun
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentRunsResponse
import aws.sdk.kotlin.services.inspector.model.FailedItemDetails
import aws.sdk.kotlin.services.inspector.model.InspectorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeAssessmentRunsOperationDeserializer: HttpDeserialize<DescribeAssessmentRunsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAssessmentRunsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAssessmentRunsError(context, response)
        }
        val builder = DescribeAssessmentRunsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAssessmentRunsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAssessmentRunsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw InspectorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> InspectorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssessmentRunsOperationBody(builder: DescribeAssessmentRunsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSESSMENTRUNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assessmentRuns"))
    val FAILEDITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("failedItems"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSESSMENTRUNS_DESCRIPTOR)
        field(FAILEDITEMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSESSMENTRUNS_DESCRIPTOR.index -> builder.assessmentRuns =
                    deserializer.deserializeList(ASSESSMENTRUNS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssessmentRun>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssessmentRunDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILEDITEMS_DESCRIPTOR.index -> builder.failedItems =
                    deserializer.deserializeMap(FAILEDITEMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FailedItemDetails>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFailedItemDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
