// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.paginators

import aws.sdk.kotlin.services.inspector.InspectorClient
import aws.sdk.kotlin.services.inspector.model.GetExclusionsPreviewRequest
import aws.sdk.kotlin.services.inspector.model.GetExclusionsPreviewResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunAgentsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunAgentsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTargetsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTargetsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTemplatesRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTemplatesResponse
import aws.sdk.kotlin.services.inspector.model.ListEventSubscriptionsRequest
import aws.sdk.kotlin.services.inspector.model.ListEventSubscriptionsResponse
import aws.sdk.kotlin.services.inspector.model.ListExclusionsRequest
import aws.sdk.kotlin.services.inspector.model.ListExclusionsResponse
import aws.sdk.kotlin.services.inspector.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector.model.ListRulesPackagesRequest
import aws.sdk.kotlin.services.inspector.model.ListRulesPackagesResponse
import aws.sdk.kotlin.services.inspector.model.PreviewAgentsRequest
import aws.sdk.kotlin.services.inspector.model.PreviewAgentsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetExclusionsPreviewResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetExclusionsPreviewRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetExclusionsPreviewResponse]
 */
public fun InspectorClient.getExclusionsPreviewPaginated(initialRequest: GetExclusionsPreviewRequest): Flow<GetExclusionsPreviewResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getExclusionsPreviewPaginated.getExclusionsPreview(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetExclusionsPreviewResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetExclusionsPreviewResponse]
 */
public fun InspectorClient.getExclusionsPreviewPaginated(block: GetExclusionsPreviewRequest.Builder.() -> Unit): Flow<GetExclusionsPreviewResponse> =
    getExclusionsPreviewPaginated(GetExclusionsPreviewRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentRunAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentRunAgentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentRunAgentsResponse]
 */
public fun InspectorClient.listAssessmentRunAgentsPaginated(initialRequest: ListAssessmentRunAgentsRequest): Flow<ListAssessmentRunAgentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentRunAgentsPaginated.listAssessmentRunAgents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentRunAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentRunAgentsResponse]
 */
public fun InspectorClient.listAssessmentRunAgentsPaginated(block: ListAssessmentRunAgentsRequest.Builder.() -> Unit): Flow<ListAssessmentRunAgentsResponse> =
    listAssessmentRunAgentsPaginated(ListAssessmentRunAgentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentRunsResponse]
 */
public fun InspectorClient.listAssessmentRunsPaginated(initialRequest: ListAssessmentRunsRequest): Flow<ListAssessmentRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentRunsPaginated.listAssessmentRuns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentRunsResponse]
 */
public fun InspectorClient.listAssessmentRunsPaginated(block: ListAssessmentRunsRequest.Builder.() -> Unit): Flow<ListAssessmentRunsResponse> =
    listAssessmentRunsPaginated(ListAssessmentRunsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentTargetsResponse]
 */
public fun InspectorClient.listAssessmentTargetsPaginated(initialRequest: ListAssessmentTargetsRequest): Flow<ListAssessmentTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentTargetsPaginated.listAssessmentTargets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentTargetsResponse]
 */
public fun InspectorClient.listAssessmentTargetsPaginated(block: ListAssessmentTargetsRequest.Builder.() -> Unit): Flow<ListAssessmentTargetsResponse> =
    listAssessmentTargetsPaginated(ListAssessmentTargetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentTemplatesResponse]
 */
public fun InspectorClient.listAssessmentTemplatesPaginated(initialRequest: ListAssessmentTemplatesRequest): Flow<ListAssessmentTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentTemplatesPaginated.listAssessmentTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentTemplatesResponse]
 */
public fun InspectorClient.listAssessmentTemplatesPaginated(block: ListAssessmentTemplatesRequest.Builder.() -> Unit): Flow<ListAssessmentTemplatesResponse> =
    listAssessmentTemplatesPaginated(ListAssessmentTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventSubscriptionsResponse]
 */
public fun InspectorClient.listEventSubscriptionsPaginated(initialRequest: ListEventSubscriptionsRequest): Flow<ListEventSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventSubscriptionsPaginated.listEventSubscriptions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventSubscriptionsResponse]
 */
public fun InspectorClient.listEventSubscriptionsPaginated(block: ListEventSubscriptionsRequest.Builder.() -> Unit): Flow<ListEventSubscriptionsResponse> =
    listEventSubscriptionsPaginated(ListEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExclusionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExclusionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExclusionsResponse]
 */
public fun InspectorClient.listExclusionsPaginated(initialRequest: ListExclusionsRequest): Flow<ListExclusionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExclusionsPaginated.listExclusions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExclusionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExclusionsResponse]
 */
public fun InspectorClient.listExclusionsPaginated(block: ListExclusionsRequest.Builder.() -> Unit): Flow<ListExclusionsResponse> =
    listExclusionsPaginated(ListExclusionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun InspectorClient.listFindingsPaginated(initialRequest: ListFindingsRequest): Flow<ListFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsPaginated.listFindings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun InspectorClient.listFindingsPaginated(block: ListFindingsRequest.Builder.() -> Unit): Flow<ListFindingsResponse> =
    listFindingsPaginated(ListFindingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRulesPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRulesPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesPackagesResponse]
 */
public fun InspectorClient.listRulesPackagesPaginated(initialRequest: ListRulesPackagesRequest): Flow<ListRulesPackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRulesPackagesPaginated.listRulesPackages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRulesPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesPackagesResponse]
 */
public fun InspectorClient.listRulesPackagesPaginated(block: ListRulesPackagesRequest.Builder.() -> Unit): Flow<ListRulesPackagesResponse> =
    listRulesPackagesPaginated(ListRulesPackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [PreviewAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [PreviewAgentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PreviewAgentsResponse]
 */
public fun InspectorClient.previewAgentsPaginated(initialRequest: PreviewAgentsRequest): Flow<PreviewAgentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@previewAgentsPaginated.previewAgents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [PreviewAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PreviewAgentsResponse]
 */
public fun InspectorClient.previewAgentsPaginated(block: PreviewAgentsRequest.Builder.() -> Unit): Flow<PreviewAgentsResponse> =
    previewAgentsPaginated(PreviewAgentsRequest.Builder().apply(block).build())
