// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model



/**
 * Contains information about an Amazon Inspector agent. This data type is used as a response element in the ListAssessmentRunAgents action.
 */
public class AssessmentRunAgent private constructor(builder: Builder) {
    /**
     * The current health state of the agent.
     */
    public val agentHealth: aws.sdk.kotlin.services.inspector.model.AgentHealth? = builder.agentHealth
    /**
     * The detailed health state of the agent.
     */
    public val agentHealthCode: aws.sdk.kotlin.services.inspector.model.AgentHealthCode? = builder.agentHealthCode
    /**
     * The description for the agent health code.
     */
    public val agentHealthDetails: kotlin.String? = builder.agentHealthDetails
    /**
     * The AWS account of the EC2 instance where the agent is installed.
     */
    public val agentId: kotlin.String? = builder.agentId
    /**
     * The ARN of the assessment run that is associated with the agent.
     */
    public val assessmentRunArn: kotlin.String? = builder.assessmentRunArn
    /**
     * The Auto Scaling group of the EC2 instance that is specified by the agent ID.
     */
    public val autoScalingGroup: kotlin.String? = builder.autoScalingGroup
    /**
     * The Amazon Inspector application data metrics that are collected by the agent.
     */
    public val telemetryMetadata: List<TelemetryMetadata>? = builder.telemetryMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentRunAgent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentRunAgent(")
        append("agentHealth=$agentHealth,")
        append("agentHealthCode=$agentHealthCode,")
        append("agentHealthDetails=$agentHealthDetails,")
        append("agentId=$agentId,")
        append("assessmentRunArn=$assessmentRunArn,")
        append("autoScalingGroup=$autoScalingGroup,")
        append("telemetryMetadata=$telemetryMetadata")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentHealth?.hashCode() ?: 0
        result = 31 * result + (agentHealthCode?.hashCode() ?: 0)
        result = 31 * result + (agentHealthDetails?.hashCode() ?: 0)
        result = 31 * result + (agentId?.hashCode() ?: 0)
        result = 31 * result + (assessmentRunArn?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroup?.hashCode() ?: 0)
        result = 31 * result + (telemetryMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentRunAgent

        if (agentHealth != other.agentHealth) return false
        if (agentHealthCode != other.agentHealthCode) return false
        if (agentHealthDetails != other.agentHealthDetails) return false
        if (agentId != other.agentId) return false
        if (assessmentRunArn != other.assessmentRunArn) return false
        if (autoScalingGroup != other.autoScalingGroup) return false
        if (telemetryMetadata != other.telemetryMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentRunAgent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current health state of the agent.
         */
        public var agentHealth: aws.sdk.kotlin.services.inspector.model.AgentHealth? = null
        /**
         * The detailed health state of the agent.
         */
        public var agentHealthCode: aws.sdk.kotlin.services.inspector.model.AgentHealthCode? = null
        /**
         * The description for the agent health code.
         */
        public var agentHealthDetails: kotlin.String? = null
        /**
         * The AWS account of the EC2 instance where the agent is installed.
         */
        public var agentId: kotlin.String? = null
        /**
         * The ARN of the assessment run that is associated with the agent.
         */
        public var assessmentRunArn: kotlin.String? = null
        /**
         * The Auto Scaling group of the EC2 instance that is specified by the agent ID.
         */
        public var autoScalingGroup: kotlin.String? = null
        /**
         * The Amazon Inspector application data metrics that are collected by the agent.
         */
        public var telemetryMetadata: List<TelemetryMetadata>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentRunAgent) : this() {
            this.agentHealth = x.agentHealth
            this.agentHealthCode = x.agentHealthCode
            this.agentHealthDetails = x.agentHealthDetails
            this.agentId = x.agentId
            this.assessmentRunArn = x.assessmentRunArn
            this.autoScalingGroup = x.autoScalingGroup
            this.telemetryMetadata = x.telemetryMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentRunAgent = AssessmentRunAgent(this)
    }
}
