// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.inspector.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.inspector.endpoints.EndpointProvider
import aws.sdk.kotlin.services.inspector.model.*
import aws.sdk.kotlin.services.inspector.model.AddAttributesToFindingsRequest
import aws.sdk.kotlin.services.inspector.model.AddAttributesToFindingsResponse
import aws.sdk.kotlin.services.inspector.model.CreateAssessmentTargetRequest
import aws.sdk.kotlin.services.inspector.model.CreateAssessmentTargetResponse
import aws.sdk.kotlin.services.inspector.model.CreateAssessmentTemplateRequest
import aws.sdk.kotlin.services.inspector.model.CreateAssessmentTemplateResponse
import aws.sdk.kotlin.services.inspector.model.CreateExclusionsPreviewRequest
import aws.sdk.kotlin.services.inspector.model.CreateExclusionsPreviewResponse
import aws.sdk.kotlin.services.inspector.model.CreateResourceGroupRequest
import aws.sdk.kotlin.services.inspector.model.CreateResourceGroupResponse
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentRunRequest
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentRunResponse
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentTargetRequest
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentTargetResponse
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentTemplateRequest
import aws.sdk.kotlin.services.inspector.model.DeleteAssessmentTemplateResponse
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentRunsRequest
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentRunsResponse
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentTargetsRequest
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentTargetsResponse
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentTemplatesRequest
import aws.sdk.kotlin.services.inspector.model.DescribeAssessmentTemplatesResponse
import aws.sdk.kotlin.services.inspector.model.DescribeCrossAccountAccessRoleRequest
import aws.sdk.kotlin.services.inspector.model.DescribeCrossAccountAccessRoleResponse
import aws.sdk.kotlin.services.inspector.model.DescribeExclusionsRequest
import aws.sdk.kotlin.services.inspector.model.DescribeExclusionsResponse
import aws.sdk.kotlin.services.inspector.model.DescribeFindingsRequest
import aws.sdk.kotlin.services.inspector.model.DescribeFindingsResponse
import aws.sdk.kotlin.services.inspector.model.DescribeResourceGroupsRequest
import aws.sdk.kotlin.services.inspector.model.DescribeResourceGroupsResponse
import aws.sdk.kotlin.services.inspector.model.DescribeRulesPackagesRequest
import aws.sdk.kotlin.services.inspector.model.DescribeRulesPackagesResponse
import aws.sdk.kotlin.services.inspector.model.GetAssessmentReportRequest
import aws.sdk.kotlin.services.inspector.model.GetAssessmentReportResponse
import aws.sdk.kotlin.services.inspector.model.GetExclusionsPreviewRequest
import aws.sdk.kotlin.services.inspector.model.GetExclusionsPreviewResponse
import aws.sdk.kotlin.services.inspector.model.GetTelemetryMetadataRequest
import aws.sdk.kotlin.services.inspector.model.GetTelemetryMetadataResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunAgentsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunAgentsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentRunsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTargetsRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTargetsResponse
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTemplatesRequest
import aws.sdk.kotlin.services.inspector.model.ListAssessmentTemplatesResponse
import aws.sdk.kotlin.services.inspector.model.ListEventSubscriptionsRequest
import aws.sdk.kotlin.services.inspector.model.ListEventSubscriptionsResponse
import aws.sdk.kotlin.services.inspector.model.ListExclusionsRequest
import aws.sdk.kotlin.services.inspector.model.ListExclusionsResponse
import aws.sdk.kotlin.services.inspector.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector.model.ListRulesPackagesRequest
import aws.sdk.kotlin.services.inspector.model.ListRulesPackagesResponse
import aws.sdk.kotlin.services.inspector.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.inspector.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.inspector.model.PreviewAgentsRequest
import aws.sdk.kotlin.services.inspector.model.PreviewAgentsResponse
import aws.sdk.kotlin.services.inspector.model.RegisterCrossAccountAccessRoleRequest
import aws.sdk.kotlin.services.inspector.model.RegisterCrossAccountAccessRoleResponse
import aws.sdk.kotlin.services.inspector.model.RemoveAttributesFromFindingsRequest
import aws.sdk.kotlin.services.inspector.model.RemoveAttributesFromFindingsResponse
import aws.sdk.kotlin.services.inspector.model.SetTagsForResourceRequest
import aws.sdk.kotlin.services.inspector.model.SetTagsForResourceResponse
import aws.sdk.kotlin.services.inspector.model.StartAssessmentRunRequest
import aws.sdk.kotlin.services.inspector.model.StartAssessmentRunResponse
import aws.sdk.kotlin.services.inspector.model.StopAssessmentRunRequest
import aws.sdk.kotlin.services.inspector.model.StopAssessmentRunResponse
import aws.sdk.kotlin.services.inspector.model.SubscribeToEventRequest
import aws.sdk.kotlin.services.inspector.model.SubscribeToEventResponse
import aws.sdk.kotlin.services.inspector.model.UnsubscribeFromEventRequest
import aws.sdk.kotlin.services.inspector.model.UnsubscribeFromEventResponse
import aws.sdk.kotlin.services.inspector.model.UpdateAssessmentTargetRequest
import aws.sdk.kotlin.services.inspector.model.UpdateAssessmentTargetResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * # Amazon Inspector
 * Amazon Inspector enables you to analyze the behavior of your AWS resources and to identify potential security issues. For more information, see [ Amazon Inspector User Guide](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html).
 */
public interface InspectorClient : SdkClient {

    override val serviceName: String
        get() = "Inspector"
    /**
     * InspectorClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): InspectorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultInspectorClient(config)
        }

        public operator fun invoke(config: Config): InspectorClient = DefaultInspectorClient(config)

        /**
         * Construct a [InspectorClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): InspectorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultInspectorClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Inspector")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     */
    public suspend fun addAttributesToFindings(input: AddAttributesToFindingsRequest): AddAttributesToFindingsResponse

    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see [ Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     */
    public suspend fun createAssessmentTarget(input: CreateAssessmentTargetRequest): CreateAssessmentTargetResponse

    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.
     */
    public suspend fun createAssessmentTemplate(input: CreateAssessmentTemplateRequest): CreateAssessmentTemplateResponse

    /**
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     */
    public suspend fun createExclusionsPreview(input: CreateExclusionsPreviewRequest): CreateExclusionsPreviewResponse

    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see CreateAssessmentTarget.
     */
    public suspend fun createResourceGroup(input: CreateResourceGroupRequest): CreateResourceGroupResponse

    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     */
    public suspend fun deleteAssessmentRun(input: DeleteAssessmentRunRequest): DeleteAssessmentRunResponse

    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     */
    public suspend fun deleteAssessmentTarget(input: DeleteAssessmentTargetRequest): DeleteAssessmentTargetResponse

    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     */
    public suspend fun deleteAssessmentTemplate(input: DeleteAssessmentTemplateRequest): DeleteAssessmentTemplateResponse

    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     */
    public suspend fun describeAssessmentRuns(input: DescribeAssessmentRunsRequest): DescribeAssessmentRunsResponse

    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     */
    public suspend fun describeAssessmentTargets(input: DescribeAssessmentTargetsRequest): DescribeAssessmentTargetsResponse

    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     */
    public suspend fun describeAssessmentTemplates(input: DescribeAssessmentTemplatesRequest): DescribeAssessmentTemplatesResponse

    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     */
    public suspend fun describeCrossAccountAccessRole(input: DescribeCrossAccountAccessRoleRequest = DescribeCrossAccountAccessRoleRequest {}): DescribeCrossAccountAccessRoleResponse

    /**
     * Describes the exclusions that are specified by the exclusions' ARNs.
     */
    public suspend fun describeExclusions(input: DescribeExclusionsRequest): DescribeExclusionsResponse

    /**
     * Describes the findings that are specified by the ARNs of the findings.
     */
    public suspend fun describeFindings(input: DescribeFindingsRequest): DescribeFindingsResponse

    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     */
    public suspend fun describeResourceGroups(input: DescribeResourceGroupsRequest): DescribeResourceGroupsResponse

    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     */
    public suspend fun describeRulesPackages(input: DescribeRulesPackagesRequest): DescribeRulesPackagesResponse

    /**
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     */
    public suspend fun getAssessmentReport(input: GetAssessmentReportRequest): GetAssessmentReportResponse

    /**
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.
     */
    public suspend fun getExclusionsPreview(input: GetExclusionsPreviewRequest): GetExclusionsPreviewResponse

    /**
     * Information about the data that is collected for the specified assessment run.
     */
    public suspend fun getTelemetryMetadata(input: GetTelemetryMetadataRequest): GetTelemetryMetadataResponse

    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     */
    public suspend fun listAssessmentRunAgents(input: ListAssessmentRunAgentsRequest): ListAssessmentRunAgentsResponse

    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     */
    public suspend fun listAssessmentRuns(input: ListAssessmentRunsRequest = ListAssessmentRunsRequest {}): ListAssessmentRunsResponse

    /**
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     */
    public suspend fun listAssessmentTargets(input: ListAssessmentTargetsRequest = ListAssessmentTargetsRequest {}): ListAssessmentTargetsResponse

    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     */
    public suspend fun listAssessmentTemplates(input: ListAssessmentTemplatesRequest = ListAssessmentTemplatesRequest {}): ListAssessmentTemplatesResponse

    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see SubscribeToEvent and UnsubscribeFromEvent.
     */
    public suspend fun listEventSubscriptions(input: ListEventSubscriptionsRequest = ListEventSubscriptionsRequest {}): ListEventSubscriptionsResponse

    /**
     * List exclusions that are generated by the assessment run.
     */
    public suspend fun listExclusions(input: ListExclusionsRequest): ListExclusionsResponse

    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     */
    public suspend fun listFindings(input: ListFindingsRequest = ListFindingsRequest {}): ListFindingsResponse

    /**
     * Lists all available Amazon Inspector rules packages.
     */
    public suspend fun listRulesPackages(input: ListRulesPackagesRequest = ListRulesPackagesRequest {}): ListRulesPackagesResponse

    /**
     * Lists all tags associated with an assessment template.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     */
    public suspend fun previewAgents(input: PreviewAgentsRequest): PreviewAgentsResponse

    /**
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.
     */
    public suspend fun registerCrossAccountAccessRole(input: RegisterCrossAccountAccessRoleRequest): RegisterCrossAccountAccessRoleResponse

    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     */
    public suspend fun removeAttributesFromFindings(input: RemoveAttributesFromFindingsRequest): RemoveAttributesFromFindingsResponse

    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     */
    public suspend fun setTagsForResource(input: SetTagsForResourceRequest): SetTagsForResourceResponse

    /**
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
     */
    public suspend fun startAssessmentRun(input: StartAssessmentRunRequest): StartAssessmentRunResponse

    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     */
    public suspend fun stopAssessmentRun(input: StopAssessmentRunRequest): StopAssessmentRunResponse

    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     */
    public suspend fun subscribeToEvent(input: SubscribeToEventRequest): SubscribeToEventResponse

    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     */
    public suspend fun unsubscribeFromEvent(input: UnsubscribeFromEventRequest): UnsubscribeFromEventResponse

    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     */
    public suspend fun updateAssessmentTarget(input: UpdateAssessmentTargetRequest): UpdateAssessmentTargetResponse
}

/**
 * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
 */
public suspend inline fun InspectorClient.addAttributesToFindings(crossinline block: AddAttributesToFindingsRequest.Builder.() -> Unit): AddAttributesToFindingsResponse = addAttributesToFindings(AddAttributesToFindingsRequest.Builder().apply(block).build())

/**
 * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see [ Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
 */
public suspend inline fun InspectorClient.createAssessmentTarget(crossinline block: CreateAssessmentTargetRequest.Builder.() -> Unit): CreateAssessmentTargetResponse = createAssessmentTarget(CreateAssessmentTargetRequest.Builder().apply(block).build())

/**
 * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.
 */
public suspend inline fun InspectorClient.createAssessmentTemplate(crossinline block: CreateAssessmentTemplateRequest.Builder.() -> Unit): CreateAssessmentTemplateResponse = createAssessmentTemplate(CreateAssessmentTemplateRequest.Builder().apply(block).build())

/**
 * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
 */
public suspend inline fun InspectorClient.createExclusionsPreview(crossinline block: CreateExclusionsPreviewRequest.Builder.() -> Unit): CreateExclusionsPreviewResponse = createExclusionsPreview(CreateExclusionsPreviewRequest.Builder().apply(block).build())

/**
 * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see CreateAssessmentTarget.
 */
public suspend inline fun InspectorClient.createResourceGroup(crossinline block: CreateResourceGroupRequest.Builder.() -> Unit): CreateResourceGroupResponse = createResourceGroup(CreateResourceGroupRequest.Builder().apply(block).build())

/**
 * Deletes the assessment run that is specified by the ARN of the assessment run.
 */
public suspend inline fun InspectorClient.deleteAssessmentRun(crossinline block: DeleteAssessmentRunRequest.Builder.() -> Unit): DeleteAssessmentRunResponse = deleteAssessmentRun(DeleteAssessmentRunRequest.Builder().apply(block).build())

/**
 * Deletes the assessment target that is specified by the ARN of the assessment target.
 */
public suspend inline fun InspectorClient.deleteAssessmentTarget(crossinline block: DeleteAssessmentTargetRequest.Builder.() -> Unit): DeleteAssessmentTargetResponse = deleteAssessmentTarget(DeleteAssessmentTargetRequest.Builder().apply(block).build())

/**
 * Deletes the assessment template that is specified by the ARN of the assessment template.
 */
public suspend inline fun InspectorClient.deleteAssessmentTemplate(crossinline block: DeleteAssessmentTemplateRequest.Builder.() -> Unit): DeleteAssessmentTemplateResponse = deleteAssessmentTemplate(DeleteAssessmentTemplateRequest.Builder().apply(block).build())

/**
 * Describes the assessment runs that are specified by the ARNs of the assessment runs.
 */
public suspend inline fun InspectorClient.describeAssessmentRuns(crossinline block: DescribeAssessmentRunsRequest.Builder.() -> Unit): DescribeAssessmentRunsResponse = describeAssessmentRuns(DescribeAssessmentRunsRequest.Builder().apply(block).build())

/**
 * Describes the assessment targets that are specified by the ARNs of the assessment targets.
 */
public suspend inline fun InspectorClient.describeAssessmentTargets(crossinline block: DescribeAssessmentTargetsRequest.Builder.() -> Unit): DescribeAssessmentTargetsResponse = describeAssessmentTargets(DescribeAssessmentTargetsRequest.Builder().apply(block).build())

/**
 * Describes the assessment templates that are specified by the ARNs of the assessment templates.
 */
public suspend inline fun InspectorClient.describeAssessmentTemplates(crossinline block: DescribeAssessmentTemplatesRequest.Builder.() -> Unit): DescribeAssessmentTemplatesResponse = describeAssessmentTemplates(DescribeAssessmentTemplatesRequest.Builder().apply(block).build())

/**
 * Describes the IAM role that enables Amazon Inspector to access your AWS account.
 */
public suspend inline fun InspectorClient.describeCrossAccountAccessRole(crossinline block: DescribeCrossAccountAccessRoleRequest.Builder.() -> Unit): DescribeCrossAccountAccessRoleResponse = describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest.Builder().apply(block).build())

/**
 * Describes the exclusions that are specified by the exclusions' ARNs.
 */
public suspend inline fun InspectorClient.describeExclusions(crossinline block: DescribeExclusionsRequest.Builder.() -> Unit): DescribeExclusionsResponse = describeExclusions(DescribeExclusionsRequest.Builder().apply(block).build())

/**
 * Describes the findings that are specified by the ARNs of the findings.
 */
public suspend inline fun InspectorClient.describeFindings(crossinline block: DescribeFindingsRequest.Builder.() -> Unit): DescribeFindingsResponse = describeFindings(DescribeFindingsRequest.Builder().apply(block).build())

/**
 * Describes the resource groups that are specified by the ARNs of the resource groups.
 */
public suspend inline fun InspectorClient.describeResourceGroups(crossinline block: DescribeResourceGroupsRequest.Builder.() -> Unit): DescribeResourceGroupsResponse = describeResourceGroups(DescribeResourceGroupsRequest.Builder().apply(block).build())

/**
 * Describes the rules packages that are specified by the ARNs of the rules packages.
 */
public suspend inline fun InspectorClient.describeRulesPackages(crossinline block: DescribeRulesPackagesRequest.Builder.() -> Unit): DescribeRulesPackagesResponse = describeRulesPackages(DescribeRulesPackagesRequest.Builder().apply(block).build())

/**
 * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
 */
public suspend inline fun InspectorClient.getAssessmentReport(crossinline block: GetAssessmentReportRequest.Builder.() -> Unit): GetAssessmentReportResponse = getAssessmentReport(GetAssessmentReportRequest.Builder().apply(block).build())

/**
 * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.
 */
public suspend inline fun InspectorClient.getExclusionsPreview(crossinline block: GetExclusionsPreviewRequest.Builder.() -> Unit): GetExclusionsPreviewResponse = getExclusionsPreview(GetExclusionsPreviewRequest.Builder().apply(block).build())

/**
 * Information about the data that is collected for the specified assessment run.
 */
public suspend inline fun InspectorClient.getTelemetryMetadata(crossinline block: GetTelemetryMetadataRequest.Builder.() -> Unit): GetTelemetryMetadataResponse = getTelemetryMetadata(GetTelemetryMetadataRequest.Builder().apply(block).build())

/**
 * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
 */
public suspend inline fun InspectorClient.listAssessmentRunAgents(crossinline block: ListAssessmentRunAgentsRequest.Builder.() -> Unit): ListAssessmentRunAgentsResponse = listAssessmentRunAgents(ListAssessmentRunAgentsRequest.Builder().apply(block).build())

/**
 * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
 */
public suspend inline fun InspectorClient.listAssessmentRuns(crossinline block: ListAssessmentRunsRequest.Builder.() -> Unit): ListAssessmentRunsResponse = listAssessmentRuns(ListAssessmentRunsRequest.Builder().apply(block).build())

/**
 * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
 */
public suspend inline fun InspectorClient.listAssessmentTargets(crossinline block: ListAssessmentTargetsRequest.Builder.() -> Unit): ListAssessmentTargetsResponse = listAssessmentTargets(ListAssessmentTargetsRequest.Builder().apply(block).build())

/**
 * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
 */
public suspend inline fun InspectorClient.listAssessmentTemplates(crossinline block: ListAssessmentTemplatesRequest.Builder.() -> Unit): ListAssessmentTemplatesResponse = listAssessmentTemplates(ListAssessmentTemplatesRequest.Builder().apply(block).build())

/**
 * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see SubscribeToEvent and UnsubscribeFromEvent.
 */
public suspend inline fun InspectorClient.listEventSubscriptions(crossinline block: ListEventSubscriptionsRequest.Builder.() -> Unit): ListEventSubscriptionsResponse = listEventSubscriptions(ListEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * List exclusions that are generated by the assessment run.
 */
public suspend inline fun InspectorClient.listExclusions(crossinline block: ListExclusionsRequest.Builder.() -> Unit): ListExclusionsResponse = listExclusions(ListExclusionsRequest.Builder().apply(block).build())

/**
 * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
 */
public suspend inline fun InspectorClient.listFindings(crossinline block: ListFindingsRequest.Builder.() -> Unit): ListFindingsResponse = listFindings(ListFindingsRequest.Builder().apply(block).build())

/**
 * Lists all available Amazon Inspector rules packages.
 */
public suspend inline fun InspectorClient.listRulesPackages(crossinline block: ListRulesPackagesRequest.Builder.() -> Unit): ListRulesPackagesResponse = listRulesPackages(ListRulesPackagesRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with an assessment template.
 */
public suspend inline fun InspectorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
 */
public suspend inline fun InspectorClient.previewAgents(crossinline block: PreviewAgentsRequest.Builder.() -> Unit): PreviewAgentsResponse = previewAgents(PreviewAgentsRequest.Builder().apply(block).build())

/**
 * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.
 */
public suspend inline fun InspectorClient.registerCrossAccountAccessRole(crossinline block: RegisterCrossAccountAccessRoleRequest.Builder.() -> Unit): RegisterCrossAccountAccessRoleResponse = registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest.Builder().apply(block).build())

/**
 * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
 */
public suspend inline fun InspectorClient.removeAttributesFromFindings(crossinline block: RemoveAttributesFromFindingsRequest.Builder.() -> Unit): RemoveAttributesFromFindingsResponse = removeAttributesFromFindings(RemoveAttributesFromFindingsRequest.Builder().apply(block).build())

/**
 * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
 */
public suspend inline fun InspectorClient.setTagsForResource(crossinline block: SetTagsForResourceRequest.Builder.() -> Unit): SetTagsForResourceResponse = setTagsForResource(SetTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
 */
public suspend inline fun InspectorClient.startAssessmentRun(crossinline block: StartAssessmentRunRequest.Builder.() -> Unit): StartAssessmentRunResponse = startAssessmentRun(StartAssessmentRunRequest.Builder().apply(block).build())

/**
 * Stops the assessment run that is specified by the ARN of the assessment run.
 */
public suspend inline fun InspectorClient.stopAssessmentRun(crossinline block: StopAssessmentRunRequest.Builder.() -> Unit): StopAssessmentRunResponse = stopAssessmentRun(StopAssessmentRunRequest.Builder().apply(block).build())

/**
 * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
 */
public suspend inline fun InspectorClient.subscribeToEvent(crossinline block: SubscribeToEventRequest.Builder.() -> Unit): SubscribeToEventResponse = subscribeToEvent(SubscribeToEventRequest.Builder().apply(block).build())

/**
 * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
 */
public suspend inline fun InspectorClient.unsubscribeFromEvent(crossinline block: UnsubscribeFromEventRequest.Builder.() -> Unit): UnsubscribeFromEventResponse = unsubscribeFromEvent(UnsubscribeFromEventRequest.Builder().apply(block).build())

/**
 * Updates the assessment target that is specified by the ARN of the assessment target.
 *
 * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
 */
public suspend inline fun InspectorClient.updateAssessmentTarget(crossinline block: UpdateAssessmentTargetRequest.Builder.() -> Unit): UpdateAssessmentTargetResponse = updateAssessmentTarget(UpdateAssessmentTargetRequest.Builder().apply(block).build())
