// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains runtime details for an instance of a workflow that ran for the associated image build version.
 */
public class WorkflowStepExecution private constructor(builder: Builder) {
    /**
     * The name of the step action.
     */
    public val action: kotlin.String? = builder.action
    /**
     * The Amazon Resource Name (ARN) of the image build version that ran the workflow.
     */
    public val imageBuildVersionArn: kotlin.String? = builder.imageBuildVersionArn
    /**
     * The name of the workflow step.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The timestamp when the workflow step started.
     */
    public val startTime: kotlin.String? = builder.startTime
    /**
     * Uniquely identifies the workflow step that ran for the associated image build version.
     */
    public val stepExecutionId: kotlin.String? = builder.stepExecutionId
    /**
     * The ARN of the workflow resource that ran.
     */
    public val workflowBuildVersionArn: kotlin.String? = builder.workflowBuildVersionArn
    /**
     * Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the associated image build version.
     */
    public val workflowExecutionId: kotlin.String? = builder.workflowExecutionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowStepExecution(")
        append("action=$action,")
        append("imageBuildVersionArn=$imageBuildVersionArn,")
        append("name=$name,")
        append("startTime=$startTime,")
        append("stepExecutionId=$stepExecutionId,")
        append("workflowBuildVersionArn=$workflowBuildVersionArn,")
        append("workflowExecutionId=$workflowExecutionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (imageBuildVersionArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (stepExecutionId?.hashCode() ?: 0)
        result = 31 * result + (workflowBuildVersionArn?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowStepExecution

        if (action != other.action) return false
        if (imageBuildVersionArn != other.imageBuildVersionArn) return false
        if (name != other.name) return false
        if (startTime != other.startTime) return false
        if (stepExecutionId != other.stepExecutionId) return false
        if (workflowBuildVersionArn != other.workflowBuildVersionArn) return false
        if (workflowExecutionId != other.workflowExecutionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecution = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the step action.
         */
        public var action: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the image build version that ran the workflow.
         */
        public var imageBuildVersionArn: kotlin.String? = null
        /**
         * The name of the workflow step.
         */
        public var name: kotlin.String? = null
        /**
         * The timestamp when the workflow step started.
         */
        public var startTime: kotlin.String? = null
        /**
         * Uniquely identifies the workflow step that ran for the associated image build version.
         */
        public var stepExecutionId: kotlin.String? = null
        /**
         * The ARN of the workflow resource that ran.
         */
        public var workflowBuildVersionArn: kotlin.String? = null
        /**
         * Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the associated image build version.
         */
        public var workflowExecutionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecution) : this() {
            this.action = x.action
            this.imageBuildVersionArn = x.imageBuildVersionArn
            this.name = x.name
            this.startTime = x.startTime
            this.stepExecutionId = x.stepExecutionId
            this.workflowBuildVersionArn = x.workflowBuildVersionArn
            this.workflowExecutionId = x.workflowExecutionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecution = WorkflowStepExecution(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
