// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ImportVmImageRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description for the base image that is created by the import process.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the base image that is created by the import process.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version for the imported VM.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The operating system platform for the imported VM.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * Tags that are attached to the import resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The `importTaskId` (API) or `ImportTaskId` (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.
     */
    public val vmImportTaskId: kotlin.String? = builder.vmImportTaskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportVmImageRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("platform=$platform,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("vmImportTaskId=$vmImportTaskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vmImportTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportVmImageRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (platform != other.platform) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (vmImportTaskId != other.vmImportTaskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description for the base image that is created by the import process.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the base image that is created by the import process.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version for the imported VM.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The operating system platform for the imported VM.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * Tags that are attached to the import resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * The `importTaskId` (API) or `ImportTaskId` (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.
         */
        public var vmImportTaskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.name = x.name
            this.osVersion = x.osVersion
            this.platform = x.platform
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.vmImportTaskId = x.vmImportTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest = ImportVmImageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
