// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An image summary.
 */
public class ImageSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the image.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Indicates the type of build that created this image. The build can be initiated in the following ways:
     * + **USER_INITIATED** – A manual pipeline build request.
     * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
     * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
     * + **IMPORT_ISO** – An ISO disk import created the image.
     */
    public val buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = builder.buildType
    /**
     * The date on which Image Builder created this image.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The time when deprecation occurs for an image resource. This can be a past or future date.
     */
    public val deprecationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deprecationTime
    /**
     * The origin of the base image that Image Builder used to build this image.
     */
    public val imageSource: aws.sdk.kotlin.services.imagebuilder.model.ImageSource? = builder.imageSource
    /**
     * Identifies the last runtime instance of the lifecycle policy to take action on the image.
     */
    public val lifecycleExecutionId: kotlin.String? = builder.lifecycleExecutionId
    /**
     * The name of the image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version of the instances that launch from this image. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The output resources that Image Builder produced when it created this image.
     */
    public val outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = builder.outputResources
    /**
     * The owner of the image.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The image operating system platform, such as Linux or Windows.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The state of the image.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = builder.state
    /**
     * The tags that apply to this image.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether this image produces an AMI or a container image.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = builder.type
    /**
     * The version of the image.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageSummary(")
        append("arn=$arn,")
        append("buildType=$buildType,")
        append("dateCreated=$dateCreated,")
        append("deprecationTime=$deprecationTime,")
        append("imageSource=$imageSource,")
        append("lifecycleExecutionId=$lifecycleExecutionId,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("outputResources=$outputResources,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (buildType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (deprecationTime?.hashCode() ?: 0)
        result = 31 * result + (imageSource?.hashCode() ?: 0)
        result = 31 * result + (lifecycleExecutionId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (outputResources?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageSummary

        if (arn != other.arn) return false
        if (buildType != other.buildType) return false
        if (dateCreated != other.dateCreated) return false
        if (deprecationTime != other.deprecationTime) return false
        if (imageSource != other.imageSource) return false
        if (lifecycleExecutionId != other.lifecycleExecutionId) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (outputResources != other.outputResources) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the image.
         */
        public var arn: kotlin.String? = null
        /**
         * Indicates the type of build that created this image. The build can be initiated in the following ways:
         * + **USER_INITIATED** – A manual pipeline build request.
         * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
         * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
         * + **IMPORT_ISO** – An ISO disk import created the image.
         */
        public var buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = null
        /**
         * The date on which Image Builder created this image.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The time when deprecation occurs for an image resource. This can be a past or future date.
         */
        public var deprecationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The origin of the base image that Image Builder used to build this image.
         */
        public var imageSource: aws.sdk.kotlin.services.imagebuilder.model.ImageSource? = null
        /**
         * Identifies the last runtime instance of the lifecycle policy to take action on the image.
         */
        public var lifecycleExecutionId: kotlin.String? = null
        /**
         * The name of the image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version of the instances that launch from this image. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The output resources that Image Builder produced when it created this image.
         */
        public var outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = null
        /**
         * The owner of the image.
         */
        public var owner: kotlin.String? = null
        /**
         * The image operating system platform, such as Linux or Windows.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The state of the image.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = null
        /**
         * The tags that apply to this image.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies whether this image produces an AMI or a container image.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = null
        /**
         * The version of the image.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageSummary) : this() {
            this.arn = x.arn
            this.buildType = x.buildType
            this.dateCreated = x.dateCreated
            this.deprecationTime = x.deprecationTime
            this.imageSource = x.imageSource
            this.lifecycleExecutionId = x.lifecycleExecutionId
            this.name = x.name
            this.osVersion = x.osVersion
            this.outputResources = x.outputResources
            this.owner = x.owner
            this.platform = x.platform
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = ImageSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.OutputResources] inside the given [block]
         */
        public fun outputResources(block: aws.sdk.kotlin.services.imagebuilder.model.OutputResources.Builder.() -> kotlin.Unit) {
            this.outputResources = aws.sdk.kotlin.services.imagebuilder.model.OutputResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.ImageState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.ImageState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
