// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the source of the score, and the factors that determined the adjustments to create the final score.
 */
public class CvssScoreDetails private constructor(builder: Builder) {
    /**
     * An object that contains details about an adjustment that Amazon Inspector made to the CVSS score for the finding.
     */
    public val adjustments: List<CvssScoreAdjustment>? = builder.adjustments
    /**
     * The source of the finding.
     */
    public val cvssSource: kotlin.String? = builder.cvssSource
    /**
     * The CVSS score.
     */
    public val score: kotlin.Double? = builder.score
    /**
     * The source for the CVSS score.
     */
    public val scoreSource: kotlin.String? = builder.scoreSource
    /**
     * A vector that measures the severity of the vulnerability.
     */
    public val scoringVector: kotlin.String? = builder.scoringVector
    /**
     * The CVSS version that generated the score.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CvssScoreDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CvssScoreDetails(")
        append("adjustments=$adjustments,")
        append("cvssSource=$cvssSource,")
        append("score=$score,")
        append("scoreSource=$scoreSource,")
        append("scoringVector=$scoringVector,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustments?.hashCode() ?: 0
        result = 31 * result + (cvssSource?.hashCode() ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (scoreSource?.hashCode() ?: 0)
        result = 31 * result + (scoringVector?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CvssScoreDetails

        if (adjustments != other.adjustments) return false
        if (cvssSource != other.cvssSource) return false
        if (!(score?.equals(other.score) ?: (other.score == null))) return false
        if (scoreSource != other.scoreSource) return false
        if (scoringVector != other.scoringVector) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CvssScoreDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that contains details about an adjustment that Amazon Inspector made to the CVSS score for the finding.
         */
        public var adjustments: List<CvssScoreAdjustment>? = null
        /**
         * The source of the finding.
         */
        public var cvssSource: kotlin.String? = null
        /**
         * The CVSS score.
         */
        public var score: kotlin.Double? = null
        /**
         * The source for the CVSS score.
         */
        public var scoreSource: kotlin.String? = null
        /**
         * A vector that measures the severity of the vulnerability.
         */
        public var scoringVector: kotlin.String? = null
        /**
         * The CVSS version that generated the score.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CvssScoreDetails) : this() {
            this.adjustments = x.adjustments
            this.cvssSource = x.cvssSource
            this.score = x.score
            this.scoreSource = x.scoreSource
            this.scoringVector = x.scoringVector
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CvssScoreDetails = CvssScoreDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
