// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.imagebuilder.auth.DefaultImagebuilderAuthSchemeProvider
import aws.sdk.kotlin.services.imagebuilder.auth.ImagebuilderAuthSchemeProvider
import aws.sdk.kotlin.services.imagebuilder.endpoints.DefaultImagebuilderEndpointProvider
import aws.sdk.kotlin.services.imagebuilder.endpoints.ImagebuilderEndpointParameters
import aws.sdk.kotlin.services.imagebuilder.endpoints.ImagebuilderEndpointProvider
import aws.sdk.kotlin.services.imagebuilder.model.CancelImageCreationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CancelImageCreationResponse
import aws.sdk.kotlin.services.imagebuilder.model.CancelLifecycleExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.CancelLifecycleExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteLifecyclePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteLifecyclePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteWorkflowResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentPolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentPolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetLifecycleExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetLifecycleExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetLifecyclePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetLifecyclePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetMarketplaceResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetMarketplaceResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowStepExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowStepExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.ImportComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecyclePoliciesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecyclePoliciesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWaitingWorkflowStepsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWaitingWorkflowStepsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutComponentPolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutComponentPolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutContainerRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutContainerRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutImagePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutImagePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutImageRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutImageRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.SendWorkflowStepActionRequest
import aws.sdk.kotlin.services.imagebuilder.model.SendWorkflowStepActionResponse
import aws.sdk.kotlin.services.imagebuilder.model.StartImagePipelineExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.StartImagePipelineExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.StartResourceStateUpdateRequest
import aws.sdk.kotlin.services.imagebuilder.model.StartResourceStateUpdateResponse
import aws.sdk.kotlin.services.imagebuilder.model.TagResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.TagResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.UntagResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.UntagResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateLifecyclePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateLifecyclePolicyResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "imagebuilder"
public const val SdkVersion: String = "1.5.40"
public const val ServiceApiVersion: String = "2019-12-02"

/**
 * EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the creation, management, and deployment of customized, secure, and up-to-date "golden" server images that are pre-installed and pre-configured with software and settings to meet specific IT standards.
 */
public interface ImagebuilderClient : SdkClient {
    /**
     * ImagebuilderClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ImagebuilderClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Imagebuilder",
                "IMAGEBUILDER",
                "imagebuilder",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ImagebuilderClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ImagebuilderClient = DefaultImagebuilderClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ImagebuilderEndpointProvider = builder.endpointProvider ?: DefaultImagebuilderEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ImagebuilderAuthSchemeProvider = builder.authSchemeProvider ?: DefaultImagebuilderAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "imagebuilder"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ImagebuilderEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ImagebuilderAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
     */
    public suspend fun cancelImageCreation(input: CancelImageCreationRequest): CancelImageCreationResponse

    /**
     * Cancel a specific image lifecycle policy runtime instance.
     */
    public suspend fun cancelLifecycleExecution(input: CancelLifecycleExecutionRequest): CancelLifecycleExecutionResponse

    /**
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
     * + Inline, using the `data` property in the request body.
     * + A URL that points to a YAML document file stored in Amazon S3, using the `uri` property in the request body.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     */
    public suspend fun createContainerRecipe(input: CreateContainerRecipeRequest): CreateContainerRecipeResponse

    /**
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    public suspend fun createDistributionConfiguration(input: CreateDistributionConfigurationRequest): CreateDistributionConfigurationResponse

    /**
     * Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
     */
    public suspend fun createImage(input: CreateImageRequest): CreateImageResponse

    /**
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     */
    public suspend fun createImagePipeline(input: CreateImagePipelineRequest): CreateImagePipelineResponse

    /**
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     */
    public suspend fun createImageRecipe(input: CreateImageRecipeRequest): CreateImageRecipeResponse

    /**
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    public suspend fun createInfrastructureConfiguration(input: CreateInfrastructureConfigurationRequest): CreateInfrastructureConfigurationResponse

    /**
     * Create a lifecycle policy resource.
     */
    public suspend fun createLifecyclePolicy(input: CreateLifecyclePolicyRequest): CreateLifecyclePolicyResponse

    /**
     * Create a new workflow or a new version of an existing workflow.
     */
    public suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse

    /**
     * Deletes a component build version.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a container recipe.
     */
    public suspend fun deleteContainerRecipe(input: DeleteContainerRecipeRequest): DeleteContainerRecipeResponse

    /**
     * Deletes a distribution configuration.
     */
    public suspend fun deleteDistributionConfiguration(input: DeleteDistributionConfigurationRequest): DeleteDistributionConfigurationResponse

    /**
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
     * + To deregister an EC2 Linux AMI, see [Deregister your Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html) in the **Amazon EC2 User Guide**.
     * + To deregister an EC2 Windows AMI, see [Deregister your Windows AMI](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html) in the **Amazon EC2 Windows Guide**.
     * + To delete a container image from Amazon ECR, see [Deleting an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html) in the *Amazon ECR User Guide*.
     */
    public suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse

    /**
     * Deletes an image pipeline.
     */
    public suspend fun deleteImagePipeline(input: DeleteImagePipelineRequest): DeleteImagePipelineResponse

    /**
     * Deletes an image recipe.
     */
    public suspend fun deleteImageRecipe(input: DeleteImageRecipeRequest): DeleteImageRecipeResponse

    /**
     * Deletes an infrastructure configuration.
     */
    public suspend fun deleteInfrastructureConfiguration(input: DeleteInfrastructureConfigurationRequest): DeleteInfrastructureConfigurationResponse

    /**
     * Delete the specified lifecycle policy resource.
     */
    public suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Deletes a specific workflow resource.
     */
    public suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Gets a component object.
     */
    public suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Gets a component policy.
     */
    public suspend fun getComponentPolicy(input: GetComponentPolicyRequest): GetComponentPolicyResponse

    /**
     * Retrieves a container recipe.
     */
    public suspend fun getContainerRecipe(input: GetContainerRecipeRequest): GetContainerRecipeResponse

    /**
     * Retrieves the policy for a container recipe.
     */
    public suspend fun getContainerRecipePolicy(input: GetContainerRecipePolicyRequest): GetContainerRecipePolicyResponse

    /**
     * Gets a distribution configuration.
     */
    public suspend fun getDistributionConfiguration(input: GetDistributionConfigurationRequest): GetDistributionConfigurationResponse

    /**
     * Gets an image.
     */
    public suspend fun getImage(input: GetImageRequest): GetImageResponse

    /**
     * Gets an image pipeline.
     */
    public suspend fun getImagePipeline(input: GetImagePipelineRequest): GetImagePipelineResponse

    /**
     * Gets an image policy.
     */
    public suspend fun getImagePolicy(input: GetImagePolicyRequest): GetImagePolicyResponse

    /**
     * Gets an image recipe.
     */
    public suspend fun getImageRecipe(input: GetImageRecipeRequest): GetImageRecipeResponse

    /**
     * Gets an image recipe policy.
     */
    public suspend fun getImageRecipePolicy(input: GetImageRecipePolicyRequest): GetImageRecipePolicyResponse

    /**
     * Gets an infrastructure configuration.
     */
    public suspend fun getInfrastructureConfiguration(input: GetInfrastructureConfigurationRequest): GetInfrastructureConfigurationResponse

    /**
     * Get the runtime information that was logged for a specific runtime instance of the lifecycle policy.
     */
    public suspend fun getLifecycleExecution(input: GetLifecycleExecutionRequest): GetLifecycleExecutionResponse

    /**
     * Get details for the specified image lifecycle policy.
     */
    public suspend fun getLifecyclePolicy(input: GetLifecyclePolicyRequest): GetLifecyclePolicyResponse

    /**
     * Verify the subscription and perform resource dependency checks on the requested Amazon Web Services Marketplace resource. For Amazon Web Services Marketplace components, the response contains fields to download the components and their artifacts.
     */
    public suspend fun getMarketplaceResource(input: GetMarketplaceResourceRequest): GetMarketplaceResourceResponse

    /**
     * Get a workflow resource object.
     */
    public suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Get the runtime information that was logged for a specific runtime instance of the workflow.
     */
    public suspend fun getWorkflowExecution(input: GetWorkflowExecutionRequest): GetWorkflowExecutionResponse

    /**
     * Get the runtime information that was logged for a specific runtime instance of the workflow step.
     */
    public suspend fun getWorkflowStepExecution(input: GetWorkflowStepExecutionRequest): GetWorkflowStepExecutionResponse

    /**
     * Imports a component and transforms its data into a component document.
     */
    public suspend fun importComponent(input: ImportComponentRequest): ImportComponentResponse

    /**
     * Import a Windows operating system image from a verified Microsoft ISO disk file. The following disk images are supported:
     * + Windows 11 Enterprise
     */
    public suspend fun importDiskImage(input: ImportDiskImageRequest): ImportDiskImageResponse

    /**
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
     *
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.
     */
    public suspend fun importVmImage(input: ImportVmImageRequest): ImportVmImageResponse

    /**
     * Returns the list of component build versions for the specified component version Amazon Resource Name (ARN).
     */
    public suspend fun listComponentBuildVersions(input: ListComponentBuildVersionsRequest): ListComponentBuildVersionsResponse

    /**
     * Returns the list of components that can be filtered by name, or by using the listed `filters` to streamline results. Newly created components can take up to two minutes to appear in the ListComponents API Results.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public suspend fun listComponents(input: ListComponentsRequest = ListComponentsRequest { }): ListComponentsResponse

    /**
     * Returns a list of container recipes.
     */
    public suspend fun listContainerRecipes(input: ListContainerRecipesRequest = ListContainerRecipesRequest { }): ListContainerRecipesResponse

    /**
     * Returns a list of distribution configurations.
     */
    public suspend fun listDistributionConfigurations(input: ListDistributionConfigurationsRequest = ListDistributionConfigurationsRequest { }): ListDistributionConfigurationsResponse

    /**
     * Returns a list of image build versions.
     */
    public suspend fun listImageBuildVersions(input: ListImageBuildVersionsRequest): ListImageBuildVersionsResponse

    /**
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
     */
    public suspend fun listImagePackages(input: ListImagePackagesRequest): ListImagePackagesResponse

    /**
     * Returns a list of images created by the specified pipeline.
     */
    public suspend fun listImagePipelineImages(input: ListImagePipelineImagesRequest): ListImagePipelineImagesResponse

    /**
     * Returns a list of image pipelines.
     */
    public suspend fun listImagePipelines(input: ListImagePipelinesRequest = ListImagePipelinesRequest { }): ListImagePipelinesResponse

    /**
     * Returns a list of image recipes.
     */
    public suspend fun listImageRecipes(input: ListImageRecipesRequest = ListImageRecipesRequest { }): ListImageRecipesResponse

    /**
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder uses to group results. For example, if you want to get a list of findings by severity level for one of your pipelines, you might specify your pipeline with the `imagePipelineArn` filter. If you don't specify a filter, Image Builder returns an aggregation for your account.
     *
     * To streamline results, you can use the following filters in your request:
     * + `accountId`
     * + `imageBuildVersionArn`
     * + `imagePipelineArn`
     * + `vulnerabilityId`
     */
    public suspend fun listImageScanFindingAggregations(input: ListImageScanFindingAggregationsRequest = ListImageScanFindingAggregationsRequest { }): ListImageScanFindingAggregationsResponse

    /**
     * Returns a list of image scan findings for your account.
     */
    public suspend fun listImageScanFindings(input: ListImageScanFindingsRequest = ListImageScanFindingsRequest { }): ListImageScanFindingsResponse

    /**
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in the ListImages API Results.
     */
    public suspend fun listImages(input: ListImagesRequest = ListImagesRequest { }): ListImagesResponse

    /**
     * Returns a list of infrastructure configurations.
     */
    public suspend fun listInfrastructureConfigurations(input: ListInfrastructureConfigurationsRequest = ListInfrastructureConfigurationsRequest { }): ListInfrastructureConfigurationsResponse

    /**
     * List resources that the runtime instance of the image lifecycle identified for lifecycle actions.
     */
    public suspend fun listLifecycleExecutionResources(input: ListLifecycleExecutionResourcesRequest): ListLifecycleExecutionResourcesResponse

    /**
     * Get the lifecycle runtime history for the specified resource.
     */
    public suspend fun listLifecycleExecutions(input: ListLifecycleExecutionsRequest): ListLifecycleExecutionsResponse

    /**
     * Get a list of lifecycle policies in your Amazon Web Services account.
     */
    public suspend fun listLifecyclePolicies(input: ListLifecyclePoliciesRequest = ListLifecyclePoliciesRequest { }): ListLifecyclePoliciesResponse

    /**
     * Returns the list of tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Get a list of workflow steps that are waiting for action for workflows in your Amazon Web Services account.
     */
    public suspend fun listWaitingWorkflowSteps(input: ListWaitingWorkflowStepsRequest = ListWaitingWorkflowStepsRequest { }): ListWaitingWorkflowStepsResponse

    /**
     * Returns a list of build versions for a specific workflow resource.
     */
    public suspend fun listWorkflowBuildVersions(input: ListWorkflowBuildVersionsRequest): ListWorkflowBuildVersionsResponse

    /**
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     */
    public suspend fun listWorkflowExecutions(input: ListWorkflowExecutionsRequest): ListWorkflowExecutionsResponse

    /**
     * Returns runtime data for each step in a runtime instance of the workflow that you specify in the request.
     */
    public suspend fun listWorkflowStepExecutions(input: ListWorkflowStepExecutionsRequest): ListWorkflowStepExecutionsResponse

    /**
     * Lists workflow build versions based on filtering parameters.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest = ListWorkflowsRequest { }): ListWorkflowsResponse

    /**
     * Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutComponentPolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putComponentPolicy(input: PutComponentPolicyRequest): PutComponentPolicyResponse

    /**
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putContainerRecipePolicy(input: PutContainerRecipePolicyRequest): PutContainerRecipePolicyResponse

    /**
     * Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImagePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putImagePolicy(input: PutImagePolicyRequest): PutImagePolicyResponse

    /**
     * Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImageRecipePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putImageRecipePolicy(input: PutImageRecipePolicyRequest): PutImageRecipePolicyResponse

    /**
     * Pauses or resumes image creation when the associated workflow runs a `WaitForAction` step.
     */
    public suspend fun sendWorkflowStepAction(input: SendWorkflowStepActionRequest): SendWorkflowStepActionResponse

    /**
     * Manually triggers a pipeline to create an image.
     */
    public suspend fun startImagePipelineExecution(input: StartImagePipelineExecutionRequest): StartImagePipelineExecutionResponse

    /**
     * Begin asynchronous resource state update for lifecycle changes to the specified image resources.
     */
    public suspend fun startResourceStateUpdate(input: StartResourceStateUpdateRequest): StartResourceStateUpdateResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    public suspend fun updateDistributionConfiguration(input: UpdateDistributionConfigurationRequest): UpdateDistributionConfigurationResponse

    /**
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images. You must specify exactly one recipe for your image, using either a `containerRecipeArn` or an `imageRecipeArn`.
     *
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.
     */
    public suspend fun updateImagePipeline(input: UpdateImagePipelineRequest): UpdateImagePipelineResponse

    /**
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    public suspend fun updateInfrastructureConfiguration(input: UpdateInfrastructureConfigurationRequest): UpdateInfrastructureConfigurationResponse

    /**
     * Update the specified lifecycle policy.
     */
    public suspend fun updateLifecyclePolicy(input: UpdateLifecyclePolicyRequest): UpdateLifecyclePolicyResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ImagebuilderClient.withConfig(block: ImagebuilderClient.Config.Builder.() -> Unit): ImagebuilderClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultImagebuilderClient(newConfig)
}

/**
 * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
 */
public suspend inline fun ImagebuilderClient.cancelImageCreation(crossinline block: CancelImageCreationRequest.Builder.() -> Unit): CancelImageCreationResponse = cancelImageCreation(CancelImageCreationRequest.Builder().apply(block).build())

/**
 * Cancel a specific image lifecycle policy runtime instance.
 */
public suspend inline fun ImagebuilderClient.cancelLifecycleExecution(crossinline block: CancelLifecycleExecutionRequest.Builder.() -> Unit): CancelLifecycleExecutionResponse = cancelLifecycleExecution(CancelLifecycleExecutionRequest.Builder().apply(block).build())

/**
 * Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
 * + Inline, using the `data` property in the request body.
 * + A URL that points to a YAML document file stored in Amazon S3, using the `uri` property in the request body.
 */
public suspend inline fun ImagebuilderClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
 */
public suspend inline fun ImagebuilderClient.createContainerRecipe(crossinline block: CreateContainerRecipeRequest.Builder.() -> Unit): CreateContainerRecipeResponse = createContainerRecipe(CreateContainerRecipeRequest.Builder().apply(block).build())

/**
 * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
 */
public suspend inline fun ImagebuilderClient.createDistributionConfiguration(crossinline block: CreateDistributionConfigurationRequest.Builder.() -> Unit): CreateDistributionConfigurationResponse = createDistributionConfiguration(CreateDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
 */
public suspend inline fun ImagebuilderClient.createImage(crossinline block: CreateImageRequest.Builder.() -> Unit): CreateImageResponse = createImage(CreateImageRequest.Builder().apply(block).build())

/**
 * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
 */
public suspend inline fun ImagebuilderClient.createImagePipeline(crossinline block: CreateImagePipelineRequest.Builder.() -> Unit): CreateImagePipelineResponse = createImagePipeline(CreateImagePipelineRequest.Builder().apply(block).build())

/**
 * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
 */
public suspend inline fun ImagebuilderClient.createImageRecipe(crossinline block: CreateImageRecipeRequest.Builder.() -> Unit): CreateImageRecipeResponse = createImageRecipe(CreateImageRecipeRequest.Builder().apply(block).build())

/**
 * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
 */
public suspend inline fun ImagebuilderClient.createInfrastructureConfiguration(crossinline block: CreateInfrastructureConfigurationRequest.Builder.() -> Unit): CreateInfrastructureConfigurationResponse = createInfrastructureConfiguration(CreateInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Create a lifecycle policy resource.
 */
public suspend inline fun ImagebuilderClient.createLifecyclePolicy(crossinline block: CreateLifecyclePolicyRequest.Builder.() -> Unit): CreateLifecyclePolicyResponse = createLifecyclePolicy(CreateLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Create a new workflow or a new version of an existing workflow.
 */
public suspend inline fun ImagebuilderClient.createWorkflow(crossinline block: CreateWorkflowRequest.Builder.() -> Unit): CreateWorkflowResponse = createWorkflow(CreateWorkflowRequest.Builder().apply(block).build())

/**
 * Deletes a component build version.
 */
public suspend inline fun ImagebuilderClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Deletes a container recipe.
 */
public suspend inline fun ImagebuilderClient.deleteContainerRecipe(crossinline block: DeleteContainerRecipeRequest.Builder.() -> Unit): DeleteContainerRecipeResponse = deleteContainerRecipe(DeleteContainerRecipeRequest.Builder().apply(block).build())

/**
 * Deletes a distribution configuration.
 */
public suspend inline fun ImagebuilderClient.deleteDistributionConfiguration(crossinline block: DeleteDistributionConfigurationRequest.Builder.() -> Unit): DeleteDistributionConfigurationResponse = deleteDistributionConfiguration(DeleteDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
 * + To deregister an EC2 Linux AMI, see [Deregister your Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html) in the **Amazon EC2 User Guide**.
 * + To deregister an EC2 Windows AMI, see [Deregister your Windows AMI](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html) in the **Amazon EC2 Windows Guide**.
 * + To delete a container image from Amazon ECR, see [Deleting an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html) in the *Amazon ECR User Guide*.
 */
public suspend inline fun ImagebuilderClient.deleteImage(crossinline block: DeleteImageRequest.Builder.() -> Unit): DeleteImageResponse = deleteImage(DeleteImageRequest.Builder().apply(block).build())

/**
 * Deletes an image pipeline.
 */
public suspend inline fun ImagebuilderClient.deleteImagePipeline(crossinline block: DeleteImagePipelineRequest.Builder.() -> Unit): DeleteImagePipelineResponse = deleteImagePipeline(DeleteImagePipelineRequest.Builder().apply(block).build())

/**
 * Deletes an image recipe.
 */
public suspend inline fun ImagebuilderClient.deleteImageRecipe(crossinline block: DeleteImageRecipeRequest.Builder.() -> Unit): DeleteImageRecipeResponse = deleteImageRecipe(DeleteImageRecipeRequest.Builder().apply(block).build())

/**
 * Deletes an infrastructure configuration.
 */
public suspend inline fun ImagebuilderClient.deleteInfrastructureConfiguration(crossinline block: DeleteInfrastructureConfigurationRequest.Builder.() -> Unit): DeleteInfrastructureConfigurationResponse = deleteInfrastructureConfiguration(DeleteInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Delete the specified lifecycle policy resource.
 */
public suspend inline fun ImagebuilderClient.deleteLifecyclePolicy(crossinline block: DeleteLifecyclePolicyRequest.Builder.() -> Unit): DeleteLifecyclePolicyResponse = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a specific workflow resource.
 */
public suspend inline fun ImagebuilderClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit): DeleteWorkflowResponse = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * Gets a component object.
 */
public suspend inline fun ImagebuilderClient.getComponent(crossinline block: GetComponentRequest.Builder.() -> Unit): GetComponentResponse = getComponent(GetComponentRequest.Builder().apply(block).build())

/**
 * Gets a component policy.
 */
public suspend inline fun ImagebuilderClient.getComponentPolicy(crossinline block: GetComponentPolicyRequest.Builder.() -> Unit): GetComponentPolicyResponse = getComponentPolicy(GetComponentPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves a container recipe.
 */
public suspend inline fun ImagebuilderClient.getContainerRecipe(crossinline block: GetContainerRecipeRequest.Builder.() -> Unit): GetContainerRecipeResponse = getContainerRecipe(GetContainerRecipeRequest.Builder().apply(block).build())

/**
 * Retrieves the policy for a container recipe.
 */
public suspend inline fun ImagebuilderClient.getContainerRecipePolicy(crossinline block: GetContainerRecipePolicyRequest.Builder.() -> Unit): GetContainerRecipePolicyResponse = getContainerRecipePolicy(GetContainerRecipePolicyRequest.Builder().apply(block).build())

/**
 * Gets a distribution configuration.
 */
public suspend inline fun ImagebuilderClient.getDistributionConfiguration(crossinline block: GetDistributionConfigurationRequest.Builder.() -> Unit): GetDistributionConfigurationResponse = getDistributionConfiguration(GetDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Gets an image.
 */
public suspend inline fun ImagebuilderClient.getImage(crossinline block: GetImageRequest.Builder.() -> Unit): GetImageResponse = getImage(GetImageRequest.Builder().apply(block).build())

/**
 * Gets an image pipeline.
 */
public suspend inline fun ImagebuilderClient.getImagePipeline(crossinline block: GetImagePipelineRequest.Builder.() -> Unit): GetImagePipelineResponse = getImagePipeline(GetImagePipelineRequest.Builder().apply(block).build())

/**
 * Gets an image policy.
 */
public suspend inline fun ImagebuilderClient.getImagePolicy(crossinline block: GetImagePolicyRequest.Builder.() -> Unit): GetImagePolicyResponse = getImagePolicy(GetImagePolicyRequest.Builder().apply(block).build())

/**
 * Gets an image recipe.
 */
public suspend inline fun ImagebuilderClient.getImageRecipe(crossinline block: GetImageRecipeRequest.Builder.() -> Unit): GetImageRecipeResponse = getImageRecipe(GetImageRecipeRequest.Builder().apply(block).build())

/**
 * Gets an image recipe policy.
 */
public suspend inline fun ImagebuilderClient.getImageRecipePolicy(crossinline block: GetImageRecipePolicyRequest.Builder.() -> Unit): GetImageRecipePolicyResponse = getImageRecipePolicy(GetImageRecipePolicyRequest.Builder().apply(block).build())

/**
 * Gets an infrastructure configuration.
 */
public suspend inline fun ImagebuilderClient.getInfrastructureConfiguration(crossinline block: GetInfrastructureConfigurationRequest.Builder.() -> Unit): GetInfrastructureConfigurationResponse = getInfrastructureConfiguration(GetInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Get the runtime information that was logged for a specific runtime instance of the lifecycle policy.
 */
public suspend inline fun ImagebuilderClient.getLifecycleExecution(crossinline block: GetLifecycleExecutionRequest.Builder.() -> Unit): GetLifecycleExecutionResponse = getLifecycleExecution(GetLifecycleExecutionRequest.Builder().apply(block).build())

/**
 * Get details for the specified image lifecycle policy.
 */
public suspend inline fun ImagebuilderClient.getLifecyclePolicy(crossinline block: GetLifecyclePolicyRequest.Builder.() -> Unit): GetLifecyclePolicyResponse = getLifecyclePolicy(GetLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Verify the subscription and perform resource dependency checks on the requested Amazon Web Services Marketplace resource. For Amazon Web Services Marketplace components, the response contains fields to download the components and their artifacts.
 */
public suspend inline fun ImagebuilderClient.getMarketplaceResource(crossinline block: GetMarketplaceResourceRequest.Builder.() -> Unit): GetMarketplaceResourceResponse = getMarketplaceResource(GetMarketplaceResourceRequest.Builder().apply(block).build())

/**
 * Get a workflow resource object.
 */
public suspend inline fun ImagebuilderClient.getWorkflow(crossinline block: GetWorkflowRequest.Builder.() -> Unit): GetWorkflowResponse = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

/**
 * Get the runtime information that was logged for a specific runtime instance of the workflow.
 */
public suspend inline fun ImagebuilderClient.getWorkflowExecution(crossinline block: GetWorkflowExecutionRequest.Builder.() -> Unit): GetWorkflowExecutionResponse = getWorkflowExecution(GetWorkflowExecutionRequest.Builder().apply(block).build())

/**
 * Get the runtime information that was logged for a specific runtime instance of the workflow step.
 */
public suspend inline fun ImagebuilderClient.getWorkflowStepExecution(crossinline block: GetWorkflowStepExecutionRequest.Builder.() -> Unit): GetWorkflowStepExecutionResponse = getWorkflowStepExecution(GetWorkflowStepExecutionRequest.Builder().apply(block).build())

/**
 * Imports a component and transforms its data into a component document.
 */
public suspend inline fun ImagebuilderClient.importComponent(crossinline block: ImportComponentRequest.Builder.() -> Unit): ImportComponentResponse = importComponent(ImportComponentRequest.Builder().apply(block).build())

/**
 * Import a Windows operating system image from a verified Microsoft ISO disk file. The following disk images are supported:
 * + Windows 11 Enterprise
 */
public suspend inline fun ImagebuilderClient.importDiskImage(crossinline block: ImportDiskImageRequest.Builder.() -> Unit): ImportDiskImageResponse = importDiskImage(ImportDiskImageRequest.Builder().apply(block).build())

/**
 * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
 *
 * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.
 */
public suspend inline fun ImagebuilderClient.importVmImage(crossinline block: ImportVmImageRequest.Builder.() -> Unit): ImportVmImageResponse = importVmImage(ImportVmImageRequest.Builder().apply(block).build())

/**
 * Returns the list of component build versions for the specified component version Amazon Resource Name (ARN).
 */
public suspend inline fun ImagebuilderClient.listComponentBuildVersions(crossinline block: ListComponentBuildVersionsRequest.Builder.() -> Unit): ListComponentBuildVersionsResponse = listComponentBuildVersions(ListComponentBuildVersionsRequest.Builder().apply(block).build())

/**
 * Returns the list of components that can be filtered by name, or by using the listed `filters` to streamline results. Newly created components can take up to two minutes to appear in the ListComponents API Results.
 *
 * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
 *
 * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
 */
public suspend inline fun ImagebuilderClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Returns a list of container recipes.
 */
public suspend inline fun ImagebuilderClient.listContainerRecipes(crossinline block: ListContainerRecipesRequest.Builder.() -> Unit): ListContainerRecipesResponse = listContainerRecipes(ListContainerRecipesRequest.Builder().apply(block).build())

/**
 * Returns a list of distribution configurations.
 */
public suspend inline fun ImagebuilderClient.listDistributionConfigurations(crossinline block: ListDistributionConfigurationsRequest.Builder.() -> Unit): ListDistributionConfigurationsResponse = listDistributionConfigurations(ListDistributionConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of image build versions.
 */
public suspend inline fun ImagebuilderClient.listImageBuildVersions(crossinline block: ListImageBuildVersionsRequest.Builder.() -> Unit): ListImageBuildVersionsResponse = listImageBuildVersions(ListImageBuildVersionsRequest.Builder().apply(block).build())

/**
 * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
 */
public suspend inline fun ImagebuilderClient.listImagePackages(crossinline block: ListImagePackagesRequest.Builder.() -> Unit): ListImagePackagesResponse = listImagePackages(ListImagePackagesRequest.Builder().apply(block).build())

/**
 * Returns a list of images created by the specified pipeline.
 */
public suspend inline fun ImagebuilderClient.listImagePipelineImages(crossinline block: ListImagePipelineImagesRequest.Builder.() -> Unit): ListImagePipelineImagesResponse = listImagePipelineImages(ListImagePipelineImagesRequest.Builder().apply(block).build())

/**
 * Returns a list of image pipelines.
 */
public suspend inline fun ImagebuilderClient.listImagePipelines(crossinline block: ListImagePipelinesRequest.Builder.() -> Unit): ListImagePipelinesResponse = listImagePipelines(ListImagePipelinesRequest.Builder().apply(block).build())

/**
 * Returns a list of image recipes.
 */
public suspend inline fun ImagebuilderClient.listImageRecipes(crossinline block: ListImageRecipesRequest.Builder.() -> Unit): ListImageRecipesResponse = listImageRecipes(ListImageRecipesRequest.Builder().apply(block).build())

/**
 * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder uses to group results. For example, if you want to get a list of findings by severity level for one of your pipelines, you might specify your pipeline with the `imagePipelineArn` filter. If you don't specify a filter, Image Builder returns an aggregation for your account.
 *
 * To streamline results, you can use the following filters in your request:
 * + `accountId`
 * + `imageBuildVersionArn`
 * + `imagePipelineArn`
 * + `vulnerabilityId`
 */
public suspend inline fun ImagebuilderClient.listImageScanFindingAggregations(crossinline block: ListImageScanFindingAggregationsRequest.Builder.() -> Unit): ListImageScanFindingAggregationsResponse = listImageScanFindingAggregations(ListImageScanFindingAggregationsRequest.Builder().apply(block).build())

/**
 * Returns a list of image scan findings for your account.
 */
public suspend inline fun ImagebuilderClient.listImageScanFindings(crossinline block: ListImageScanFindingsRequest.Builder.() -> Unit): ListImageScanFindingsResponse = listImageScanFindings(ListImageScanFindingsRequest.Builder().apply(block).build())

/**
 * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in the ListImages API Results.
 */
public suspend inline fun ImagebuilderClient.listImages(crossinline block: ListImagesRequest.Builder.() -> Unit): ListImagesResponse = listImages(ListImagesRequest.Builder().apply(block).build())

/**
 * Returns a list of infrastructure configurations.
 */
public suspend inline fun ImagebuilderClient.listInfrastructureConfigurations(crossinline block: ListInfrastructureConfigurationsRequest.Builder.() -> Unit): ListInfrastructureConfigurationsResponse = listInfrastructureConfigurations(ListInfrastructureConfigurationsRequest.Builder().apply(block).build())

/**
 * List resources that the runtime instance of the image lifecycle identified for lifecycle actions.
 */
public suspend inline fun ImagebuilderClient.listLifecycleExecutionResources(crossinline block: ListLifecycleExecutionResourcesRequest.Builder.() -> Unit): ListLifecycleExecutionResourcesResponse = listLifecycleExecutionResources(ListLifecycleExecutionResourcesRequest.Builder().apply(block).build())

/**
 * Get the lifecycle runtime history for the specified resource.
 */
public suspend inline fun ImagebuilderClient.listLifecycleExecutions(crossinline block: ListLifecycleExecutionsRequest.Builder.() -> Unit): ListLifecycleExecutionsResponse = listLifecycleExecutions(ListLifecycleExecutionsRequest.Builder().apply(block).build())

/**
 * Get a list of lifecycle policies in your Amazon Web Services account.
 */
public suspend inline fun ImagebuilderClient.listLifecyclePolicies(crossinline block: ListLifecyclePoliciesRequest.Builder.() -> Unit): ListLifecyclePoliciesResponse = listLifecyclePolicies(ListLifecyclePoliciesRequest.Builder().apply(block).build())

/**
 * Returns the list of tags for the specified resource.
 */
public suspend inline fun ImagebuilderClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Get a list of workflow steps that are waiting for action for workflows in your Amazon Web Services account.
 */
public suspend inline fun ImagebuilderClient.listWaitingWorkflowSteps(crossinline block: ListWaitingWorkflowStepsRequest.Builder.() -> Unit): ListWaitingWorkflowStepsResponse = listWaitingWorkflowSteps(ListWaitingWorkflowStepsRequest.Builder().apply(block).build())

/**
 * Returns a list of build versions for a specific workflow resource.
 */
public suspend inline fun ImagebuilderClient.listWorkflowBuildVersions(crossinline block: ListWorkflowBuildVersionsRequest.Builder.() -> Unit): ListWorkflowBuildVersionsResponse = listWorkflowBuildVersions(ListWorkflowBuildVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of workflow runtime instance metadata objects for a specific image build version.
 */
public suspend inline fun ImagebuilderClient.listWorkflowExecutions(crossinline block: ListWorkflowExecutionsRequest.Builder.() -> Unit): ListWorkflowExecutionsResponse = listWorkflowExecutions(ListWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * Returns runtime data for each step in a runtime instance of the workflow that you specify in the request.
 */
public suspend inline fun ImagebuilderClient.listWorkflowStepExecutions(crossinline block: ListWorkflowStepExecutionsRequest.Builder.() -> Unit): ListWorkflowStepExecutionsResponse = listWorkflowStepExecutions(ListWorkflowStepExecutionsRequest.Builder().apply(block).build())

/**
 * Lists workflow build versions based on filtering parameters.
 */
public suspend inline fun ImagebuilderClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutComponentPolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putComponentPolicy(crossinline block: PutComponentPolicyRequest.Builder.() -> Unit): PutComponentPolicyResponse = putComponentPolicy(PutComponentPolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putContainerRecipePolicy(crossinline block: PutContainerRecipePolicyRequest.Builder.() -> Unit): PutContainerRecipePolicyResponse = putContainerRecipePolicy(PutContainerRecipePolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImagePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putImagePolicy(crossinline block: PutImagePolicyRequest.Builder.() -> Unit): PutImagePolicyResponse = putImagePolicy(PutImagePolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImageRecipePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putImageRecipePolicy(crossinline block: PutImageRecipePolicyRequest.Builder.() -> Unit): PutImageRecipePolicyResponse = putImageRecipePolicy(PutImageRecipePolicyRequest.Builder().apply(block).build())

/**
 * Pauses or resumes image creation when the associated workflow runs a `WaitForAction` step.
 */
public suspend inline fun ImagebuilderClient.sendWorkflowStepAction(crossinline block: SendWorkflowStepActionRequest.Builder.() -> Unit): SendWorkflowStepActionResponse = sendWorkflowStepAction(SendWorkflowStepActionRequest.Builder().apply(block).build())

/**
 * Manually triggers a pipeline to create an image.
 */
public suspend inline fun ImagebuilderClient.startImagePipelineExecution(crossinline block: StartImagePipelineExecutionRequest.Builder.() -> Unit): StartImagePipelineExecutionResponse = startImagePipelineExecution(StartImagePipelineExecutionRequest.Builder().apply(block).build())

/**
 * Begin asynchronous resource state update for lifecycle changes to the specified image resources.
 */
public suspend inline fun ImagebuilderClient.startResourceStateUpdate(crossinline block: StartResourceStateUpdateRequest.Builder.() -> Unit): StartResourceStateUpdateResponse = startResourceStateUpdate(StartResourceStateUpdateRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun ImagebuilderClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun ImagebuilderClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
 */
public suspend inline fun ImagebuilderClient.updateDistributionConfiguration(crossinline block: UpdateDistributionConfigurationRequest.Builder.() -> Unit): UpdateDistributionConfigurationResponse = updateDistributionConfiguration(UpdateDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images. You must specify exactly one recipe for your image, using either a `containerRecipeArn` or an `imageRecipeArn`.
 *
 * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.
 */
public suspend inline fun ImagebuilderClient.updateImagePipeline(crossinline block: UpdateImagePipelineRequest.Builder.() -> Unit): UpdateImagePipelineResponse = updateImagePipeline(UpdateImagePipelineRequest.Builder().apply(block).build())

/**
 * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
 */
public suspend inline fun ImagebuilderClient.updateInfrastructureConfiguration(crossinline block: UpdateInfrastructureConfigurationRequest.Builder.() -> Unit): UpdateInfrastructureConfigurationResponse = updateInfrastructureConfiguration(UpdateInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Update the specified lifecycle policy.
 */
public suspend inline fun ImagebuilderClient.updateLifecyclePolicy(crossinline block: UpdateLifecyclePolicyRequest.Builder.() -> Unit): UpdateLifecyclePolicyResponse = updateLifecyclePolicy(UpdateLifecyclePolicyRequest.Builder().apply(block).build())
