// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.serde

import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListWorkflowStepExecutionsOperationDeserializer: HttpDeserializer.NonStreaming<ListWorkflowStepExecutionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListWorkflowStepExecutionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListWorkflowStepExecutionsError(context, call, payload)
        }
        val builder = ListWorkflowStepExecutionsResponse.Builder()

        if (payload != null) {
            deserializeListWorkflowStepExecutionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListWorkflowStepExecutionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListWorkflowStepExecutionsOperationBody(builder: ListWorkflowStepExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMAGEBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("imageBuildVersionArn"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val STEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("steps"))
    val WORKFLOWBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowBuildVersionArn"))
    val WORKFLOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMAGEBUILDVERSIONARN_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(STEPS_DESCRIPTOR)
        field(WORKFLOWBUILDVERSIONARN_DESCRIPTOR)
        field(WORKFLOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMAGEBUILDVERSIONARN_DESCRIPTOR.index -> builder.imageBuildVersionArn = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                STEPS_DESCRIPTOR.index -> builder.steps =
                    deserializer.deserializeList(STEPS_DESCRIPTOR) {
                        val col0 = mutableListOf<WorkflowStepMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkflowStepMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WORKFLOWBUILDVERSIONARN_DESCRIPTOR.index -> builder.workflowBuildVersionArn = deserializeString()
                WORKFLOWEXECUTIONID_DESCRIPTOR.index -> builder.workflowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
