// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains control settings and configurable inputs for a workflow resource.
 */
public class WorkflowConfiguration private constructor(builder: Builder) {
    /**
     * The action to take if the workflow fails.
     */
    public val onFailure: aws.sdk.kotlin.services.imagebuilder.model.OnWorkflowFailure? = builder.onFailure
    /**
     * Test workflows are defined within named runtime groups called parallel groups. The parallel group is the named group that contains this test workflow. Test workflows within a parallel group can run at the same time. Image Builder starts up to five test workflows in the group at the same time, and starts additional workflows as others complete, until all workflows in the group have completed. This field only applies for test workflows.
     */
    public val parallelGroup: kotlin.String? = builder.parallelGroup
    /**
     * Contains parameter values for each of the parameters that the workflow document defined for the workflow resource.
     */
    public val parameters: List<WorkflowParameter>? = builder.parameters
    /**
     * The Amazon Resource Name (ARN) of the workflow resource.
     */
    public val workflowArn: kotlin.String = requireNotNull(builder.workflowArn) { "A non-null value must be provided for workflowArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.WorkflowConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowConfiguration(")
        append("onFailure=$onFailure,")
        append("parallelGroup=$parallelGroup,")
        append("parameters=$parameters,")
        append("workflowArn=$workflowArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = onFailure?.hashCode() ?: 0
        result = 31 * result + (parallelGroup?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (workflowArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowConfiguration

        if (onFailure != other.onFailure) return false
        if (parallelGroup != other.parallelGroup) return false
        if (parameters != other.parameters) return false
        if (workflowArn != other.workflowArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.WorkflowConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to take if the workflow fails.
         */
        public var onFailure: aws.sdk.kotlin.services.imagebuilder.model.OnWorkflowFailure? = null
        /**
         * Test workflows are defined within named runtime groups called parallel groups. The parallel group is the named group that contains this test workflow. Test workflows within a parallel group can run at the same time. Image Builder starts up to five test workflows in the group at the same time, and starts additional workflows as others complete, until all workflows in the group have completed. This field only applies for test workflows.
         */
        public var parallelGroup: kotlin.String? = null
        /**
         * Contains parameter values for each of the parameters that the workflow document defined for the workflow resource.
         */
        public var parameters: List<WorkflowParameter>? = null
        /**
         * The Amazon Resource Name (ARN) of the workflow resource.
         */
        public var workflowArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.WorkflowConfiguration) : this() {
            this.onFailure = x.onFailure
            this.parallelGroup = x.parallelGroup
            this.parameters = x.parameters
            this.workflowArn = x.workflowArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.WorkflowConfiguration = WorkflowConfiguration(this)

        internal fun correctErrors(): Builder {
            if (workflowArn == null) workflowArn = ""
            return this
        }
    }
}
