// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Properties that configure export from your build instance to a compatible file format for your VM.
 */
public class S3ExportConfiguration private constructor(builder: Builder) {
    /**
     * Export the updated image to one of the following supported disk image formats:
     * + **Virtual Hard Disk (VHD)** – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
     * + **Stream-optimized ESX Virtual Machine Disk (VMDK)** – Compatible with VMware ESX and VMware vSphere versions 4, 5, and 6.
     * + **Raw** – Raw format.
     */
    public val diskImageFormat: aws.sdk.kotlin.services.imagebuilder.model.DiskImageFormat = requireNotNull(builder.diskImageFormat) { "A non-null value must be provided for diskImageFormat" }
    /**
     * The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
     */
    public val roleName: kotlin.String = requireNotNull(builder.roleName) { "A non-null value must be provided for roleName" }
    /**
     * The S3 bucket in which to store the output disk images for your VM.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The Amazon S3 path for the bucket where the output disk images for your VM are stored.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ExportConfiguration(")
        append("diskImageFormat=$diskImageFormat,")
        append("roleName=$roleName,")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskImageFormat.hashCode()
        result = 31 * result + (roleName.hashCode())
        result = 31 * result + (s3Bucket.hashCode())
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ExportConfiguration

        if (diskImageFormat != other.diskImageFormat) return false
        if (roleName != other.roleName) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Export the updated image to one of the following supported disk image formats:
         * + **Virtual Hard Disk (VHD)** – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.
         * + **Stream-optimized ESX Virtual Machine Disk (VMDK)** – Compatible with VMware ESX and VMware vSphere versions 4, 5, and 6.
         * + **Raw** – Raw format.
         */
        public var diskImageFormat: aws.sdk.kotlin.services.imagebuilder.model.DiskImageFormat? = null
        /**
         * The name of the role that grants VM Import/Export permission to export images to your S3 bucket.
         */
        public var roleName: kotlin.String? = null
        /**
         * The S3 bucket in which to store the output disk images for your VM.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The Amazon S3 path for the bucket where the output disk images for your VM are stored.
         */
        public var s3Prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration) : this() {
            this.diskImageFormat = x.diskImageFormat
            this.roleName = x.roleName
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration = S3ExportConfiguration(this)

        internal fun correctErrors(): Builder {
            if (diskImageFormat == null) diskImageFormat = DiskImageFormat.SdkUnknown("no value provided")
            if (roleName == null) roleName = ""
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
