// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines criteria for AMIs that are excluded from lifecycle actions.
 */
public class LifecyclePolicyDetailExclusionRulesAmis private constructor(builder: Builder) {
    /**
     * Configures whether public AMIs are excluded from the lifecycle action.
     */
    public val isPublic: kotlin.Boolean = builder.isPublic
    /**
     * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
     */
    public val lastLaunched: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched? = builder.lastLaunched
    /**
     * Configures Amazon Web Services Regions that are excluded from the lifecycle action.
     */
    public val regions: List<String>? = builder.regions
    /**
     * Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
     */
    public val sharedAccounts: List<String>? = builder.sharedAccounts
    /**
     * Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
     */
    public val tagMap: Map<String, String>? = builder.tagMap

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicyDetailExclusionRulesAmis(")
        append("isPublic=$isPublic,")
        append("lastLaunched=$lastLaunched,")
        append("regions=$regions,")
        append("sharedAccounts=$sharedAccounts,")
        append("tagMap=$tagMap")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isPublic.hashCode()
        result = 31 * result + (lastLaunched?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (sharedAccounts?.hashCode() ?: 0)
        result = 31 * result + (tagMap?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicyDetailExclusionRulesAmis

        if (isPublic != other.isPublic) return false
        if (lastLaunched != other.lastLaunched) return false
        if (regions != other.regions) return false
        if (sharedAccounts != other.sharedAccounts) return false
        if (tagMap != other.tagMap) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configures whether public AMIs are excluded from the lifecycle action.
         */
        public var isPublic: kotlin.Boolean = false
        /**
         * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
         */
        public var lastLaunched: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched? = null
        /**
         * Configures Amazon Web Services Regions that are excluded from the lifecycle action.
         */
        public var regions: List<String>? = null
        /**
         * Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
         */
        public var sharedAccounts: List<String>? = null
        /**
         * Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
         */
        public var tagMap: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis) : this() {
            this.isPublic = x.isPublic
            this.lastLaunched = x.lastLaunched
            this.regions = x.regions
            this.sharedAccounts = x.sharedAccounts
            this.tagMap = x.tagMap
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis = LifecyclePolicyDetailExclusionRulesAmis(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched] inside the given [block]
         */
        public fun lastLaunched(block: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder.() -> kotlin.Unit) {
            this.lastLaunched = aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
