// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration for a launch permission. The launch permission modification request is sent to the [Amazon EC2 ModifyImageAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html) API on behalf of the user for each Region they have selected to distribute the AMI. To make an AMI public, set the launch permission authorized accounts to `all`. See the examples for making an AMI public at [Amazon EC2 ModifyImageAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html).
 */
public class LaunchPermissionConfiguration private constructor(builder: Builder) {
    /**
     * The ARN for an Amazon Web Services Organization that you want to share your AMI with. For more information, see [What is Organizations?](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html).
     */
    public val organizationArns: List<String>? = builder.organizationArns
    /**
     * The ARN for an Organizations organizational unit (OU) that you want to share your AMI with. For more information about key concepts for Organizations, see [Organizations terminology and concepts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html).
     */
    public val organizationalUnitArns: List<String>? = builder.organizationalUnitArns
    /**
     * The name of the group.
     */
    public val userGroups: List<String>? = builder.userGroups
    /**
     * The Amazon Web Services account ID.
     */
    public val userIds: List<String>? = builder.userIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchPermissionConfiguration(")
        append("organizationArns=$organizationArns,")
        append("organizationalUnitArns=$organizationalUnitArns,")
        append("userGroups=$userGroups,")
        append("userIds=$userIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = organizationArns?.hashCode() ?: 0
        result = 31 * result + (organizationalUnitArns?.hashCode() ?: 0)
        result = 31 * result + (userGroups?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchPermissionConfiguration

        if (organizationArns != other.organizationArns) return false
        if (organizationalUnitArns != other.organizationalUnitArns) return false
        if (userGroups != other.userGroups) return false
        if (userIds != other.userIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN for an Amazon Web Services Organization that you want to share your AMI with. For more information, see [What is Organizations?](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html).
         */
        public var organizationArns: List<String>? = null
        /**
         * The ARN for an Organizations organizational unit (OU) that you want to share your AMI with. For more information about key concepts for Organizations, see [Organizations terminology and concepts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html).
         */
        public var organizationalUnitArns: List<String>? = null
        /**
         * The name of the group.
         */
        public var userGroups: List<String>? = null
        /**
         * The Amazon Web Services account ID.
         */
        public var userIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration) : this() {
            this.organizationArns = x.organizationArns
            this.organizationalUnitArns = x.organizationalUnitArns
            this.userGroups = x.userGroups
            this.userIds = x.userIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration = LaunchPermissionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
