// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A distribution configuration.
 */
public class DistributionConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date on which this distribution configuration was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The date on which this distribution configuration was last updated.
     */
    public val dateUpdated: kotlin.String? = builder.dateUpdated
    /**
     * The description of the distribution configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The distribution objects that apply Region-specific settings for the deployment of the image to targeted Regions.
     */
    public val distributions: List<Distribution>? = builder.distributions
    /**
     * The name of the distribution configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags of the distribution configuration.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The maximum duration in minutes for this distribution configuration.
     */
    public val timeoutMinutes: kotlin.Int = requireNotNull(builder.timeoutMinutes) { "A non-null value must be provided for timeoutMinutes" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionConfiguration(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("distributions=$distributions,")
        append("name=$name,")
        append("tags=$tags,")
        append("timeoutMinutes=$timeoutMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutMinutes)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DistributionConfiguration

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (distributions != other.distributions) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (timeoutMinutes != other.timeoutMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The date on which this distribution configuration was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The date on which this distribution configuration was last updated.
         */
        public var dateUpdated: kotlin.String? = null
        /**
         * The description of the distribution configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The distribution objects that apply Region-specific settings for the deployment of the image to targeted Regions.
         */
        public var distributions: List<Distribution>? = null
        /**
         * The name of the distribution configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The tags of the distribution configuration.
         */
        public var tags: Map<String, String>? = null
        /**
         * The maximum duration in minutes for this distribution configuration.
         */
        public var timeoutMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.distributions = x.distributions
            this.name = x.name
            this.tags = x.tags
            this.timeoutMinutes = x.timeoutMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration = DistributionConfiguration(this)

        internal fun correctErrors(): Builder {
            if (timeoutMinutes == null) timeoutMinutes = 0
            return this
        }
    }
}
