// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * By default, EC2 instances run on shared tenancy hardware. This means that multiple Amazon Web Services accounts might share the same physical hardware. When you use dedicated hardware, the physical server that hosts your instances is dedicated to your Amazon Web Services account. Instance placement settings contain the details for the physical hardware where instances that Image Builder launches during image creation will run.
 */
public class Placement private constructor(builder: Builder) {
    /**
     * The Availability Zone where your build and test instances will launch.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the Dedicated Host on which build and test instances run. This only applies if `tenancy` is `host`. If you specify the host ID, you must not specify the resource group ARN. If you specify both, Image Builder returns an error.
     */
    public val hostId: kotlin.String? = builder.hostId
    /**
     * The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances. This only applies if `tenancy` is `host`. If you specify the resource group ARN, you must not specify the host ID. If you specify both, Image Builder returns an error.
     */
    public val hostResourceGroupArn: kotlin.String? = builder.hostResourceGroupArn
    /**
     * The tenancy of the instance. An instance with a tenancy of `dedicated` runs on single-tenant hardware. An instance with a tenancy of `host` runs on a Dedicated Host.
     *
     * If tenancy is set to `host`, then you can optionally specify one target for placement – either host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement target, Amazon EC2 will try to find an available host for your build and test instances.
     */
    public val tenancy: aws.sdk.kotlin.services.imagebuilder.model.TenancyType? = builder.tenancy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Placement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Placement(")
        append("availabilityZone=$availabilityZone,")
        append("hostId=$hostId,")
        append("hostResourceGroupArn=$hostResourceGroupArn,")
        append("tenancy=$tenancy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (hostId?.hashCode() ?: 0)
        result = 31 * result + (hostResourceGroupArn?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Placement

        if (availabilityZone != other.availabilityZone) return false
        if (hostId != other.hostId) return false
        if (hostResourceGroupArn != other.hostResourceGroupArn) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Placement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone where your build and test instances will launch.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The ID of the Dedicated Host on which build and test instances run. This only applies if `tenancy` is `host`. If you specify the host ID, you must not specify the resource group ARN. If you specify both, Image Builder returns an error.
         */
        public var hostId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances. This only applies if `tenancy` is `host`. If you specify the resource group ARN, you must not specify the host ID. If you specify both, Image Builder returns an error.
         */
        public var hostResourceGroupArn: kotlin.String? = null
        /**
         * The tenancy of the instance. An instance with a tenancy of `dedicated` runs on single-tenant hardware. An instance with a tenancy of `host` runs on a Dedicated Host.
         *
         * If tenancy is set to `host`, then you can optionally specify one target for placement – either host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement target, Amazon EC2 will try to find an available host for your build and test instances.
         */
        public var tenancy: aws.sdk.kotlin.services.imagebuilder.model.TenancyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Placement) : this() {
            this.availabilityZone = x.availabilityZone
            this.hostId = x.hostId
            this.hostResourceGroupArn = x.hostResourceGroupArn
            this.tenancy = x.tenancy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Placement = Placement(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
