// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In addition to your infrastructure configuration, these settings provide an extra layer of control over your build instances. You can also specify commands to run on launch for all of your build instances.
 *
 * Image Builder does not automatically install the Systems Manager agent on Windows instances. If your base image includes the Systems Manager agent, then the AMI that you create will also include the agent. For Linux instances, if the base image does not already include the Systems Manager agent, Image Builder installs it. For Linux instances where Image Builder installs the Systems Manager agent, you can choose whether to keep it for the AMI that you create.
 */
public class AdditionalInstanceConfiguration private constructor(builder: Builder) {
    /**
     * Contains settings for the Systems Manager agent on your build instance.
     */
    public val systemsManagerAgent: aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent? = builder.systemsManagerAgent
    /**
     * Use this property to provide commands or a command script to run when you launch your build instance.
     *
     * The userDataOverride property replaces any commands that Image Builder might have added to ensure that Systems Manager is installed on your Linux build instance. If you override the user data, make sure that you add commands to install Systems Manager, if it is not pre-installed on your base image.
     *
     * The user data is always base 64 encoded. For example, the following commands are encoded as `IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$`:
     *
     * *#!/bin/bash*
     *
     * mkdir -p /var/bb/
     *
     * touch /var
     */
    public val userDataOverride: kotlin.String? = builder.userDataOverride

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdditionalInstanceConfiguration(")
        append("systemsManagerAgent=$systemsManagerAgent,")
        append("userDataOverride=$userDataOverride")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = systemsManagerAgent?.hashCode() ?: 0
        result = 31 * result + (userDataOverride?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdditionalInstanceConfiguration

        if (systemsManagerAgent != other.systemsManagerAgent) return false
        if (userDataOverride != other.userDataOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains settings for the Systems Manager agent on your build instance.
         */
        public var systemsManagerAgent: aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent? = null
        /**
         * Use this property to provide commands or a command script to run when you launch your build instance.
         *
         * The userDataOverride property replaces any commands that Image Builder might have added to ensure that Systems Manager is installed on your Linux build instance. If you override the user data, make sure that you add commands to install Systems Manager, if it is not pre-installed on your base image.
         *
         * The user data is always base 64 encoded. For example, the following commands are encoded as `IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$`:
         *
         * *#!/bin/bash*
         *
         * mkdir -p /var/bb/
         *
         * touch /var
         */
        public var userDataOverride: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration) : this() {
            this.systemsManagerAgent = x.systemsManagerAgent
            this.userDataOverride = x.userDataOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration = AdditionalInstanceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent] inside the given [block]
         */
        public fun systemsManagerAgent(block: aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent.Builder.() -> kotlin.Unit) {
            this.systemsManagerAgent = aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
