// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration for a single Parameter in the Amazon Web Services Systems Manager (SSM) Parameter Store in a given Region.
 */
public class SsmParameterConfiguration private constructor(builder: Builder) {
    /**
     * Specify the account that will own the Parameter in a given Region. During distribution, this account must be specified in distribution settings as a target account for the Region.
     */
    public val amiAccountId: kotlin.String? = builder.amiAccountId
    /**
     * The data type specifies what type of value the Parameter contains. We recommend that you use data type `aws:ec2:image`.
     */
    public val dataType: aws.sdk.kotlin.services.imagebuilder.model.SsmParameterDataType? = builder.dataType
    /**
     * This is the name of the Parameter in the target Region or account. The image distribution creates the Parameter if it doesn't already exist. Otherwise, it updates the parameter.
     */
    public val parameterName: kotlin.String = requireNotNull(builder.parameterName) { "A non-null value must be provided for parameterName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.SsmParameterConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SsmParameterConfiguration(")
        append("amiAccountId=$amiAccountId,")
        append("dataType=$dataType,")
        append("parameterName=$parameterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiAccountId?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (parameterName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SsmParameterConfiguration

        if (amiAccountId != other.amiAccountId) return false
        if (dataType != other.dataType) return false
        if (parameterName != other.parameterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.SsmParameterConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify the account that will own the Parameter in a given Region. During distribution, this account must be specified in distribution settings as a target account for the Region.
         */
        public var amiAccountId: kotlin.String? = null
        /**
         * The data type specifies what type of value the Parameter contains. We recommend that you use data type `aws:ec2:image`.
         */
        public var dataType: aws.sdk.kotlin.services.imagebuilder.model.SsmParameterDataType? = null
        /**
         * This is the name of the Parameter in the target Region or account. The image distribution creates the Parameter if it doesn't already exist. Otherwise, it updates the parameter.
         */
        public var parameterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.SsmParameterConfiguration) : this() {
            this.amiAccountId = x.amiAccountId
            this.dataType = x.dataType
            this.parameterName = x.parameterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.SsmParameterConfiguration = SsmParameterConfiguration(this)

        internal fun correctErrors(): Builder {
            if (parameterName == null) parameterName = ""
            return this
        }
    }
}
