// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A schedule configures when and how often a pipeline will automatically create a new image.
 */
public class Schedule private constructor(builder: Builder) {
    /**
     * The start condition configures when the pipeline should trigger a new image build, as follows. If no value is set Image Builder defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
     * + `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` (default) – When you use semantic version filters on the base image or components in your image recipe, EC2 Image Builder builds a new image only when there are new versions of the base image or components in your recipe that match the filter.For semantic version syntax, see [CreateComponent](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html).
     * + `EXPRESSION_MATCH_ONLY` – This condition builds a new image every time the CRON expression matches the current time.
     */
    public val pipelineExecutionStartCondition: aws.sdk.kotlin.services.imagebuilder.model.PipelineExecutionStartCondition? = builder.pipelineExecutionStartCondition
    /**
     * The cron expression determines how often EC2 Image Builder evaluates your `pipelineExecutionStartCondition`.
     *
     * For information on how to format a cron expression in Image Builder, see [Use cron expressions in EC2 Image Builder](https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html).
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Schedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Schedule(")
        append("pipelineExecutionStartCondition=$pipelineExecutionStartCondition,")
        append("scheduleExpression=$scheduleExpression,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pipelineExecutionStartCondition?.hashCode() ?: 0
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Schedule

        if (pipelineExecutionStartCondition != other.pipelineExecutionStartCondition) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Schedule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The start condition configures when the pipeline should trigger a new image build, as follows. If no value is set Image Builder defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
         * + `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` (default) – When you use semantic version filters on the base image or components in your image recipe, EC2 Image Builder builds a new image only when there are new versions of the base image or components in your recipe that match the filter.For semantic version syntax, see [CreateComponent](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html).
         * + `EXPRESSION_MATCH_ONLY` – This condition builds a new image every time the CRON expression matches the current time.
         */
        public var pipelineExecutionStartCondition: aws.sdk.kotlin.services.imagebuilder.model.PipelineExecutionStartCondition? = null
        /**
         * The cron expression determines how often EC2 Image Builder evaluates your `pipelineExecutionStartCondition`.
         *
         * For information on how to format a cron expression in Image Builder, see [Use cron expressions in EC2 Image Builder](https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html).
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Schedule) : this() {
            this.pipelineExecutionStartCondition = x.pipelineExecutionStartCondition
            this.scheduleExpression = x.scheduleExpression
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Schedule = Schedule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
