// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ImportDiskImageRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description for your disk image import.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions to import an image from a Microsoft ISO file.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching the EC2 instance on which the ISO image is built.
     */
    public val infrastructureConfigurationArn: kotlin.String? = builder.infrastructureConfigurationArn
    /**
     * The name of the image resource that's created from the import.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version for the imported image. Allowed values include the following: `Microsoft Windows 11`.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The operating system platform for the imported image. Allowed values include the following: `Windows`.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The semantic version to attach to the image that's created during the import process. This version follows the semantic version syntax.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * Tags that are attached to image resources created from the import.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The `uri` of the ISO disk file that's stored in Amazon S3.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportDiskImageRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("executionRole=$executionRole,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("platform=$platform,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportDiskImageRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (executionRole != other.executionRole) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (platform != other.platform) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description for your disk image import.
         */
        public var description: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions to import an image from a Microsoft ISO file.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching the EC2 instance on which the ISO image is built.
         */
        public var infrastructureConfigurationArn: kotlin.String? = null
        /**
         * The name of the image resource that's created from the import.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version for the imported image. Allowed values include the following: `Microsoft Windows 11`.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The operating system platform for the imported image. Allowed values include the following: `Windows`.
         */
        public var platform: kotlin.String? = null
        /**
         * The semantic version to attach to the image that's created during the import process. This version follows the semantic version syntax.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * Tags that are attached to image resources created from the import.
         */
        public var tags: Map<String, String>? = null
        /**
         * The `uri` of the ISO disk file that's stored in Amazon S3.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.executionRole = x.executionRole
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.name = x.name
            this.osVersion = x.osVersion
            this.platform = x.platform
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImportDiskImageRequest = ImportDiskImageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
