// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The defining characteristics of a specific version of an Image Builder image.
 */
public class ImageVersion private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
     *
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
     * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Indicates the type of build that created this image. The build can be initiated in the following ways:
     * + **USER_INITIATED** – A manual pipeline build request.
     * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
     * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
     * + **IMPORT_ISO** – An ISO disk import created the image.
     */
    public val buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = builder.buildType
    /**
     * The date on which this specific version of the Image Builder image was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The origin of the base image that Image Builder used to build this image.
     */
    public val imageSource: aws.sdk.kotlin.services.imagebuilder.model.ImageSource? = builder.imageSource
    /**
     * The name of this specific version of an Image Builder image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The owner of the image version.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The operating system platform of the image version, for example "Windows" or "Linux".
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * Specifies whether this image produces an AMI or a container image.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = builder.type
    /**
     * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageVersion(")
        append("arn=$arn,")
        append("buildType=$buildType,")
        append("dateCreated=$dateCreated,")
        append("imageSource=$imageSource,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (buildType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (imageSource?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageVersion

        if (arn != other.arn) return false
        if (buildType != other.buildType) return false
        if (dateCreated != other.dateCreated) return false
        if (imageSource != other.imageSource) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
         *
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
         * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         */
        public var arn: kotlin.String? = null
        /**
         * Indicates the type of build that created this image. The build can be initiated in the following ways:
         * + **USER_INITIATED** – A manual pipeline build request.
         * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
         * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
         * + **IMPORT_ISO** – An ISO disk import created the image.
         */
        public var buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = null
        /**
         * The date on which this specific version of the Image Builder image was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The origin of the base image that Image Builder used to build this image.
         */
        public var imageSource: aws.sdk.kotlin.services.imagebuilder.model.ImageSource? = null
        /**
         * The name of this specific version of an Image Builder image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The owner of the image version.
         */
        public var owner: kotlin.String? = null
        /**
         * The operating system platform of the image version, for example "Windows" or "Linux".
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * Specifies whether this image produces an AMI or a container image.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = null
        /**
         * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         *
         * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageVersion) : this() {
            this.arn = x.arn
            this.buildType = x.buildType
            this.dateCreated = x.dateCreated
            this.imageSource = x.imageSource
            this.name = x.name
            this.osVersion = x.osVersion
            this.owner = x.owner
            this.platform = x.platform
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageVersion = ImageVersion(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
