// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a vulnerability scan finding.
 */
public class ImageScanFinding private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that's associated with the finding.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time when the finding was first observed.
     */
    public val firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.firstObservedAt
    /**
     * Details about whether a fix is available for any of the packages that are identified in the finding through a version update.
     */
    public val fixAvailable: kotlin.String? = builder.fixAvailable
    /**
     * The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
     */
    public val imageBuildVersionArn: kotlin.String? = builder.imageBuildVersionArn
    /**
     * The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
     */
    public val imagePipelineArn: kotlin.String? = builder.imagePipelineArn
    /**
     * The score that Amazon Inspector assigned for the finding.
     */
    public val inspectorScore: kotlin.Double? = builder.inspectorScore
    /**
     * An object that contains details of the Amazon Inspector score.
     */
    public val inspectorScoreDetails: aws.sdk.kotlin.services.imagebuilder.model.InspectorScoreDetails? = builder.inspectorScoreDetails
    /**
     * An object that contains the details of a package vulnerability finding.
     */
    public val packageVulnerabilityDetails: aws.sdk.kotlin.services.imagebuilder.model.PackageVulnerabilityDetails? = builder.packageVulnerabilityDetails
    /**
     * An object that contains the details about how to remediate the finding.
     */
    public val remediation: aws.sdk.kotlin.services.imagebuilder.model.Remediation? = builder.remediation
    /**
     * The severity of the finding.
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The title of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The type of the finding. Image Builder looks for findings of the type `PACKAGE_VULNERABILITY` that apply to output images, and excludes other types.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The timestamp when the finding was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageScanFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageScanFinding(")
        append("awsAccountId=$awsAccountId,")
        append("description=$description,")
        append("firstObservedAt=$firstObservedAt,")
        append("fixAvailable=$fixAvailable,")
        append("imageBuildVersionArn=$imageBuildVersionArn,")
        append("imagePipelineArn=$imagePipelineArn,")
        append("inspectorScore=$inspectorScore,")
        append("inspectorScoreDetails=$inspectorScoreDetails,")
        append("packageVulnerabilityDetails=$packageVulnerabilityDetails,")
        append("remediation=$remediation,")
        append("severity=$severity,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (fixAvailable?.hashCode() ?: 0)
        result = 31 * result + (imageBuildVersionArn?.hashCode() ?: 0)
        result = 31 * result + (imagePipelineArn?.hashCode() ?: 0)
        result = 31 * result + (inspectorScore?.hashCode() ?: 0)
        result = 31 * result + (inspectorScoreDetails?.hashCode() ?: 0)
        result = 31 * result + (packageVulnerabilityDetails?.hashCode() ?: 0)
        result = 31 * result + (remediation?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageScanFinding

        if (awsAccountId != other.awsAccountId) return false
        if (description != other.description) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (fixAvailable != other.fixAvailable) return false
        if (imageBuildVersionArn != other.imageBuildVersionArn) return false
        if (imagePipelineArn != other.imagePipelineArn) return false
        if (!(inspectorScore?.equals(other.inspectorScore) ?: (other.inspectorScore == null))) return false
        if (inspectorScoreDetails != other.inspectorScoreDetails) return false
        if (packageVulnerabilityDetails != other.packageVulnerabilityDetails) return false
        if (remediation != other.remediation) return false
        if (severity != other.severity) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageScanFinding = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID that's associated with the finding.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time when the finding was first observed.
         */
        public var firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about whether a fix is available for any of the packages that are identified in the finding through a version update.
         */
        public var fixAvailable: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
         */
        public var imageBuildVersionArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
         */
        public var imagePipelineArn: kotlin.String? = null
        /**
         * The score that Amazon Inspector assigned for the finding.
         */
        public var inspectorScore: kotlin.Double? = null
        /**
         * An object that contains details of the Amazon Inspector score.
         */
        public var inspectorScoreDetails: aws.sdk.kotlin.services.imagebuilder.model.InspectorScoreDetails? = null
        /**
         * An object that contains the details of a package vulnerability finding.
         */
        public var packageVulnerabilityDetails: aws.sdk.kotlin.services.imagebuilder.model.PackageVulnerabilityDetails? = null
        /**
         * An object that contains the details about how to remediate the finding.
         */
        public var remediation: aws.sdk.kotlin.services.imagebuilder.model.Remediation? = null
        /**
         * The severity of the finding.
         */
        public var severity: kotlin.String? = null
        /**
         * The title of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the finding. Image Builder looks for findings of the type `PACKAGE_VULNERABILITY` that apply to output images, and excludes other types.
         */
        public var type: kotlin.String? = null
        /**
         * The timestamp when the finding was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageScanFinding) : this() {
            this.awsAccountId = x.awsAccountId
            this.description = x.description
            this.firstObservedAt = x.firstObservedAt
            this.fixAvailable = x.fixAvailable
            this.imageBuildVersionArn = x.imageBuildVersionArn
            this.imagePipelineArn = x.imagePipelineArn
            this.inspectorScore = x.inspectorScore
            this.inspectorScoreDetails = x.inspectorScoreDetails
            this.packageVulnerabilityDetails = x.packageVulnerabilityDetails
            this.remediation = x.remediation
            this.severity = x.severity
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageScanFinding = ImageScanFinding(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InspectorScoreDetails] inside the given [block]
         */
        public fun inspectorScoreDetails(block: aws.sdk.kotlin.services.imagebuilder.model.InspectorScoreDetails.Builder.() -> kotlin.Unit) {
            this.inspectorScoreDetails = aws.sdk.kotlin.services.imagebuilder.model.InspectorScoreDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.PackageVulnerabilityDetails] inside the given [block]
         */
        public fun packageVulnerabilityDetails(block: aws.sdk.kotlin.services.imagebuilder.model.PackageVulnerabilityDetails.Builder.() -> kotlin.Unit) {
            this.packageVulnerabilityDetails = aws.sdk.kotlin.services.imagebuilder.model.PackageVulnerabilityDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Remediation] inside the given [block]
         */
        public fun remediation(block: aws.sdk.kotlin.services.imagebuilder.model.Remediation.Builder.() -> kotlin.Unit) {
            this.remediation = aws.sdk.kotlin.services.imagebuilder.model.Remediation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
