// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a process that Image Builder uses to build and test images during the image creation process.
 */
public class Workflow private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the workflow resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.
     */
    public val changeDescription: kotlin.String? = builder.changeDescription
    /**
     * Contains the YAML document content for the workflow.
     */
    public val data: kotlin.String? = builder.data
    /**
     * The timestamp when Image Builder created the workflow resource.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The description of the workflow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The KMS key identifier used to encrypt the workflow resource.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the workflow resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the workflow resource.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * An array of input parameters that that the image workflow uses to control actions or configure settings.
     */
    public val parameters: List<WorkflowParameterDetail>? = builder.parameters
    /**
     * Describes the current status of the workflow and the reason for that status.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState? = builder.state
    /**
     * The tags that apply to the workflow resource
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and test workflows.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = builder.type
    /**
     * The workflow resource version. Workflow resources are immutable. To make a change, you can clone a workflow or create a new version.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Workflow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workflow(")
        append("arn=$arn,")
        append("changeDescription=$changeDescription,")
        append("data=$data,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("owner=$owner,")
        append("parameters=$parameters,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (changeDescription?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workflow

        if (arn != other.arn) return false
        if (changeDescription != other.changeDescription) return false
        if (data != other.data) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parameters != other.parameters) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Workflow = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the workflow resource.
         */
        public var arn: kotlin.String? = null
        /**
         * Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.
         */
        public var changeDescription: kotlin.String? = null
        /**
         * Contains the YAML document content for the workflow.
         */
        public var data: kotlin.String? = null
        /**
         * The timestamp when Image Builder created the workflow resource.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The description of the workflow.
         */
        public var description: kotlin.String? = null
        /**
         * The KMS key identifier used to encrypt the workflow resource.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the workflow resource.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the workflow resource.
         */
        public var owner: kotlin.String? = null
        /**
         * An array of input parameters that that the image workflow uses to control actions or configure settings.
         */
        public var parameters: List<WorkflowParameterDetail>? = null
        /**
         * Describes the current status of the workflow and the reason for that status.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState? = null
        /**
         * The tags that apply to the workflow resource
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and test workflows.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = null
        /**
         * The workflow resource version. Workflow resources are immutable. To make a change, you can clone a workflow or create a new version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Workflow) : this() {
            this.arn = x.arn
            this.changeDescription = x.changeDescription
            this.data = x.data
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.owner = x.owner
            this.parameters = x.parameters
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Workflow = Workflow(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.WorkflowState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.WorkflowState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
