// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container recipe.
 */
public class ContainerRecipe private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the container recipe.
     *
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
     * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Build and test components that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     */
    public val components: List<ComponentConfiguration>? = builder.components
    /**
     * Specifies the type of container, such as Docker.
     */
    public val containerType: aws.sdk.kotlin.services.imagebuilder.model.ContainerType? = builder.containerType
    /**
     * The date when this container recipe was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The description of the container recipe.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
     */
    public val dockerfileTemplateData: kotlin.String? = builder.dockerfileTemplateData
    /**
     * A flag that indicates if the target container is encrypted.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    public val instanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the container recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the container recipe.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The base image for the container recipe.
     */
    public val parentImage: kotlin.String? = builder.parentImage
    /**
     * The system platform for the container, such as Windows or Linux.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * Tags that are attached to the container recipe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The destination repository for the container image.
     */
    public val targetRepository: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository? = builder.targetRepository
    /**
     * The semantic version of the container recipe.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The working directory for use during build and test workflows.
     */
    public val workingDirectory: kotlin.String? = builder.workingDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerRecipe(")
        append("arn=$arn,")
        append("components=$components,")
        append("containerType=$containerType,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("dockerfileTemplateData=$dockerfileTemplateData,")
        append("encrypted=$encrypted,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags,")
        append("targetRepository=$targetRepository,")
        append("version=$version,")
        append("workingDirectory=$workingDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateData?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRepository?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerRecipe

        if (arn != other.arn) return false
        if (components != other.components) return false
        if (containerType != other.containerType) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (dockerfileTemplateData != other.dockerfileTemplateData) return false
        if (encrypted != other.encrypted) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false
        if (targetRepository != other.targetRepository) return false
        if (version != other.version) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the container recipe.
         *
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
         * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         */
        public var arn: kotlin.String? = null
        /**
         * Build and test components that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         */
        public var components: List<ComponentConfiguration>? = null
        /**
         * Specifies the type of container, such as Docker.
         */
        public var containerType: aws.sdk.kotlin.services.imagebuilder.model.ContainerType? = null
        /**
         * The date when this container recipe was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The description of the container recipe.
         */
        public var description: kotlin.String? = null
        /**
         * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
         */
        public var dockerfileTemplateData: kotlin.String? = null
        /**
         * A flag that indicates if the target container is encrypted.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        public var instanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration? = null
        /**
         * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the container recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the container recipe.
         */
        public var owner: kotlin.String? = null
        /**
         * The base image for the container recipe.
         */
        public var parentImage: kotlin.String? = null
        /**
         * The system platform for the container, such as Windows or Linux.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * Tags that are attached to the container recipe.
         */
        public var tags: Map<String, String>? = null
        /**
         * The destination repository for the container image.
         */
        public var targetRepository: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository? = null
        /**
         * The semantic version of the container recipe.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         *
         * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         */
        public var version: kotlin.String? = null
        /**
         * The working directory for use during build and test workflows.
         */
        public var workingDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe) : this() {
            this.arn = x.arn
            this.components = x.components
            this.containerType = x.containerType
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.dockerfileTemplateData = x.dockerfileTemplateData
            this.encrypted = x.encrypted
            this.instanceConfiguration = x.instanceConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
            this.targetRepository = x.targetRepository
            this.version = x.version
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe = ContainerRecipe(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration] inside the given [block]
         */
        public fun instanceConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceConfiguration = aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository] inside the given [block]
         */
        public fun targetRepository(block: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository.Builder.() -> kotlin.Unit) {
            this.targetRepository = aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
