// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains metadata about the workflow resource.
 */
public class WorkflowSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the workflow resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The change description for the current version of the workflow resource.
     */
    public val changeDescription: kotlin.String? = builder.changeDescription
    /**
     * The original creation date of the workflow resource.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * Describes the workflow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the workflow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the workflow resource.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * Describes the current state of the workflow resource.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState? = builder.state
    /**
     * Contains a list of tags that are defined for the workflow.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The image creation stage that this workflow applies to. Image Builder currently supports build and test stage workflows.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = builder.type
    /**
     * The version of the workflow.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.WorkflowSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowSummary(")
        append("arn=$arn,")
        append("changeDescription=$changeDescription,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (changeDescription?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowSummary

        if (arn != other.arn) return false
        if (changeDescription != other.changeDescription) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.WorkflowSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the workflow resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The change description for the current version of the workflow resource.
         */
        public var changeDescription: kotlin.String? = null
        /**
         * The original creation date of the workflow resource.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * Describes the workflow.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the workflow.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the workflow resource.
         */
        public var owner: kotlin.String? = null
        /**
         * Describes the current state of the workflow resource.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState? = null
        /**
         * Contains a list of tags that are defined for the workflow.
         */
        public var tags: Map<String, String>? = null
        /**
         * The image creation stage that this workflow applies to. Image Builder currently supports build and test stage workflows.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = null
        /**
         * The version of the workflow.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.WorkflowSummary) : this() {
            this.arn = x.arn
            this.changeDescription = x.changeDescription
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.WorkflowSummary = WorkflowSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.WorkflowState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.WorkflowState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.WorkflowState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
