// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateInfrastructureConfigurationRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the infrastructure configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
     */
    public val infrastructureConfigurationArn: kotlin.String? = builder.infrastructureConfigurationArn
    /**
     * The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:
     * + [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 User Guide** for Linux instances.
     * + [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 Windows Guide** for Windows instances.
     */
    public val instanceMetadataOptions: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions? = builder.instanceMetadataOptions
    /**
     * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     */
    public val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.
     */
    public val keyPair: kotlin.String? = builder.keyPair
    /**
     * The logging configuration of the infrastructure configuration.
     */
    public val logging: aws.sdk.kotlin.services.imagebuilder.model.Logging? = builder.logging
    /**
     * The tags attached to the resource created by Image Builder.
     */
    public val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
     *
     * EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
     */
    public val terminateInstanceOnFailure: kotlin.Boolean? = builder.terminateInstanceOnFailure

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInfrastructureConfigurationRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("instanceMetadataOptions=$instanceMetadataOptions,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("keyPair=$keyPair,")
        append("logging=$logging,")
        append("resourceTags=$resourceTags,")
        append("securityGroupIds=$securityGroupIds,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetId=$subnetId,")
        append("terminateInstanceOnFailure=$terminateInstanceOnFailure")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (instanceMetadataOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (terminateInstanceOnFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateInfrastructureConfigurationRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (instanceMetadataOptions != other.instanceMetadataOptions) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (keyPair != other.keyPair) return false
        if (logging != other.logging) return false
        if (resourceTags != other.resourceTags) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetId != other.subnetId) return false
        if (terminateInstanceOnFailure != other.terminateInstanceOnFailure) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the infrastructure configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
         */
        public var infrastructureConfigurationArn: kotlin.String? = null
        /**
         * The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:
         * + [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 User Guide** for Linux instances.
         * + [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 Windows Guide** for Windows instances.
         */
        public var instanceMetadataOptions: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions? = null
        /**
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.
         */
        public var keyPair: kotlin.String? = null
        /**
         * The logging configuration of the infrastructure configuration.
         */
        public var logging: aws.sdk.kotlin.services.imagebuilder.model.Logging? = null
        /**
         * The tags attached to the resource created by Image Builder.
         */
        public var resourceTags: Map<String, String>? = null
        /**
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
         *
         * EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
         */
        public var terminateInstanceOnFailure: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.instanceMetadataOptions = x.instanceMetadataOptions
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.keyPair = x.keyPair
            this.logging = x.logging
            this.resourceTags = x.resourceTags
            this.securityGroupIds = x.securityGroupIds
            this.snsTopicArn = x.snsTopicArn
            this.subnetId = x.subnetId
            this.terminateInstanceOnFailure = x.terminateInstanceOnFailure
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest = UpdateInfrastructureConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions] inside the given [block]
         */
        public fun instanceMetadataOptions(block: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.instanceMetadataOptions = aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.imagebuilder.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.imagebuilder.model.Logging.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
