// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The infrastructure used when building Amazon EC2 AMIs.
 */
public class InfrastructureConfigurationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date on which the infrastructure configuration was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The date on which the infrastructure configuration was last updated.
     */
    public val dateUpdated: kotlin.String? = builder.dateUpdated
    /**
     * The description of the infrastructure configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The instance profile of the infrastructure configuration.
     */
    public val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The name of the infrastructure configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags attached to the image created by Image Builder.
     */
    public val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The tags of the infrastructure configuration.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InfrastructureConfigurationSummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("name=$name,")
        append("resourceTags=$resourceTags,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InfrastructureConfigurationSummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (name != other.name) return false
        if (resourceTags != other.resourceTags) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfigurationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The date on which the infrastructure configuration was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        public var dateUpdated: kotlin.String? = null
        /**
         * The description of the infrastructure configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The instance profile of the infrastructure configuration.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The instance types of the infrastructure configuration.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The name of the infrastructure configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The tags attached to the image created by Image Builder.
         */
        public var resourceTags: Map<String, String>? = null
        /**
         * The tags of the infrastructure configuration.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfigurationSummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.name = x.name
            this.resourceTags = x.resourceTags
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfigurationSummary = InfrastructureConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
