// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configure image tests for your pipeline build. Tests run after building the image, to verify that the AMI or container image is valid before distributing it.
 */
public class ImageTestsConfiguration private constructor(builder: Builder) {
    /**
     * Determines if tests should run after building the image. Image Builder defaults to enable tests to run following the image build, before image distribution.
     */
    public val imageTestsEnabled: kotlin.Boolean? = builder.imageTestsEnabled
    /**
     * The maximum time in minutes that tests are permitted to run.
     *
     * The timeoutMinutes attribute is not currently active. This value is ignored.
     */
    public val timeoutMinutes: kotlin.Int? = builder.timeoutMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageTestsConfiguration(")
        append("imageTestsEnabled=$imageTestsEnabled,")
        append("timeoutMinutes=$timeoutMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageTestsEnabled?.hashCode() ?: 0
        result = 31 * result + (timeoutMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageTestsConfiguration

        if (imageTestsEnabled != other.imageTestsEnabled) return false
        if (timeoutMinutes != other.timeoutMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines if tests should run after building the image. Image Builder defaults to enable tests to run following the image build, before image distribution.
         */
        public var imageTestsEnabled: kotlin.Boolean? = null
        /**
         * The maximum time in minutes that tests are permitted to run.
         *
         * The timeoutMinutes attribute is not currently active. This value is ignored.
         */
        public var timeoutMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration) : this() {
            this.imageTestsEnabled = x.imageTestsEnabled
            this.timeoutMinutes = x.timeoutMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration = ImageTestsConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
