// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details of an image pipeline.
 */
public class ImagePipeline private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the image pipeline.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    public val containerRecipeArn: kotlin.String? = builder.containerRecipeArn
    /**
     * The date on which this image pipeline was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * This is no longer supported, and does not return a value.
     */
    public val dateLastRun: kotlin.String? = builder.dateLastRun
    /**
     * The next date when the pipeline is scheduled to run.
     */
    public val dateNextRun: kotlin.String? = builder.dateNextRun
    /**
     * The date on which this image pipeline was last updated.
     */
    public val dateUpdated: kotlin.String? = builder.dateUpdated
    /**
     * The description of the image pipeline.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     */
    public val distributionConfigurationArn: kotlin.String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    public val enhancedImageMetadataEnabled: kotlin.Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     */
    public val imageRecipeArn: kotlin.String? = builder.imageRecipeArn
    /**
     * Contains settings for vulnerability scans.
     */
    public val imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = builder.imageScanningConfiguration
    /**
     * The image tests configuration of the image pipeline.
     */
    public val imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    public val infrastructureConfigurationArn: kotlin.String? = builder.infrastructureConfigurationArn
    /**
     * The name of the image pipeline.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform of the image pipeline.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The schedule of the image pipeline.
     */
    public val schedule: aws.sdk.kotlin.services.imagebuilder.model.Schedule? = builder.schedule
    /**
     * The status of the image pipeline.
     */
    public val status: aws.sdk.kotlin.services.imagebuilder.model.PipelineStatus? = builder.status
    /**
     * The tags of this image pipeline.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains the workflows that run for the image pipeline.
     */
    public val workflows: List<WorkflowConfiguration>? = builder.workflows

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImagePipeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImagePipeline(")
        append("arn=$arn,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("dateCreated=$dateCreated,")
        append("dateLastRun=$dateLastRun,")
        append("dateNextRun=$dateNextRun,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("executionRole=$executionRole,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageScanningConfiguration=$imageScanningConfiguration,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("name=$name,")
        append("platform=$platform,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("tags=$tags,")
        append("workflows=$workflows")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateLastRun?.hashCode() ?: 0)
        result = 31 * result + (dateNextRun?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageScanningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workflows?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImagePipeline

        if (arn != other.arn) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateLastRun != other.dateLastRun) return false
        if (dateNextRun != other.dateNextRun) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (executionRole != other.executionRole) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageScanningConfiguration != other.imageScanningConfiguration) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (workflows != other.workflows) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImagePipeline = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the image pipeline.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         */
        public var containerRecipeArn: kotlin.String? = null
        /**
         * The date on which this image pipeline was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * This is no longer supported, and does not return a value.
         */
        public var dateLastRun: kotlin.String? = null
        /**
         * The next date when the pipeline is scheduled to run.
         */
        public var dateNextRun: kotlin.String? = null
        /**
         * The date on which this image pipeline was last updated.
         */
        public var dateUpdated: kotlin.String? = null
        /**
         * The description of the image pipeline.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
         */
        public var distributionConfigurationArn: kotlin.String? = null
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         */
        public var enhancedImageMetadataEnabled: kotlin.Boolean? = null
        /**
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
         */
        public var imageRecipeArn: kotlin.String? = null
        /**
         * Contains settings for vulnerability scans.
         */
        public var imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = null
        /**
         * The image tests configuration of the image pipeline.
         */
        public var imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
         */
        public var infrastructureConfigurationArn: kotlin.String? = null
        /**
         * The name of the image pipeline.
         */
        public var name: kotlin.String? = null
        /**
         * The platform of the image pipeline.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The schedule of the image pipeline.
         */
        public var schedule: aws.sdk.kotlin.services.imagebuilder.model.Schedule? = null
        /**
         * The status of the image pipeline.
         */
        public var status: aws.sdk.kotlin.services.imagebuilder.model.PipelineStatus? = null
        /**
         * The tags of this image pipeline.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains the workflows that run for the image pipeline.
         */
        public var workflows: List<WorkflowConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImagePipeline) : this() {
            this.arn = x.arn
            this.containerRecipeArn = x.containerRecipeArn
            this.dateCreated = x.dateCreated
            this.dateLastRun = x.dateLastRun
            this.dateNextRun = x.dateNextRun
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.executionRole = x.executionRole
            this.imageRecipeArn = x.imageRecipeArn
            this.imageScanningConfiguration = x.imageScanningConfiguration
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.name = x.name
            this.platform = x.platform
            this.schedule = x.schedule
            this.status = x.status
            this.tags = x.tags
            this.workflows = x.workflows
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImagePipeline = ImagePipeline(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration] inside the given [block]
         */
        public fun imageScanningConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.Builder.() -> kotlin.Unit) {
            this.imageScanningConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        public fun imageTestsConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.Builder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.imagebuilder.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.imagebuilder.model.Schedule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
