// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings that Image Builder uses to configure the ECR repository and the output container images that Amazon Inspector scans.
 */
public class EcrConfiguration private constructor(builder: Builder) {
    /**
     * Tags for Image Builder to apply to the output container image that &INS; scans. Tags can help you identify and manage your scanned images.
     */
    public val containerTags: List<String>? = builder.containerTags
    /**
     * The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don’t provide this information, Image Builder creates a repository in your account named `image-builder-image-scanning-repository` for vulnerability scans of your output container images.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.EcrConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcrConfiguration(")
        append("containerTags=$containerTags,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerTags?.hashCode() ?: 0
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcrConfiguration

        if (containerTags != other.containerTags) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.EcrConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Tags for Image Builder to apply to the output container image that &INS; scans. Tags can help you identify and manage your scanned images.
         */
        public var containerTags: List<String>? = null
        /**
         * The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don’t provide this information, Image Builder creates a repository in your account named `image-builder-image-scanning-repository` for vulnerability scans of your output container images.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.EcrConfiguration) : this() {
            this.containerTags = x.containerTags
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.EcrConfiguration = EcrConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
