// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the settings for a specific Region.
 */
public class Distribution private constructor(builder: Builder) {
    /**
     * The specific AMI settings; for example, launch permissions or AMI tags.
     */
    public val amiDistributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration? = builder.amiDistributionConfiguration
    /**
     * Container distribution settings for encryption, licensing, and sharing in a specific Region.
     */
    public val containerDistributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ContainerDistributionConfiguration? = builder.containerDistributionConfiguration
    /**
     * The Windows faster-launching configurations to use for AMI distribution.
     */
    public val fastLaunchConfigurations: List<FastLaunchConfiguration>? = builder.fastLaunchConfigurations
    /**
     * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
     */
    public val launchTemplateConfigurations: List<LaunchTemplateConfiguration>? = builder.launchTemplateConfigurations
    /**
     * The License Manager Configuration to associate with the AMI in the specified Region.
     */
    public val licenseConfigurationArns: List<String>? = builder.licenseConfigurationArns
    /**
     * The target Region.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * Configure export settings to deliver disk images created from your image build, using a file format that is compatible with your VMs in that Region.
     */
    public val s3ExportConfiguration: aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration? = builder.s3ExportConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Distribution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Distribution(")
        append("amiDistributionConfiguration=$amiDistributionConfiguration,")
        append("containerDistributionConfiguration=$containerDistributionConfiguration,")
        append("fastLaunchConfigurations=$fastLaunchConfigurations,")
        append("launchTemplateConfigurations=$launchTemplateConfigurations,")
        append("licenseConfigurationArns=$licenseConfigurationArns,")
        append("region=$region,")
        append("s3ExportConfiguration=$s3ExportConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiDistributionConfiguration?.hashCode() ?: 0
        result = 31 * result + (containerDistributionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fastLaunchConfigurations?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateConfigurations?.hashCode() ?: 0)
        result = 31 * result + (licenseConfigurationArns?.hashCode() ?: 0)
        result = 31 * result + (region.hashCode())
        result = 31 * result + (s3ExportConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Distribution

        if (amiDistributionConfiguration != other.amiDistributionConfiguration) return false
        if (containerDistributionConfiguration != other.containerDistributionConfiguration) return false
        if (fastLaunchConfigurations != other.fastLaunchConfigurations) return false
        if (launchTemplateConfigurations != other.launchTemplateConfigurations) return false
        if (licenseConfigurationArns != other.licenseConfigurationArns) return false
        if (region != other.region) return false
        if (s3ExportConfiguration != other.s3ExportConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Distribution = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The specific AMI settings; for example, launch permissions or AMI tags.
         */
        public var amiDistributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration? = null
        /**
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         */
        public var containerDistributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ContainerDistributionConfiguration? = null
        /**
         * The Windows faster-launching configurations to use for AMI distribution.
         */
        public var fastLaunchConfigurations: List<FastLaunchConfiguration>? = null
        /**
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         */
        public var launchTemplateConfigurations: List<LaunchTemplateConfiguration>? = null
        /**
         * The License Manager Configuration to associate with the AMI in the specified Region.
         */
        public var licenseConfigurationArns: List<String>? = null
        /**
         * The target Region.
         */
        public var region: kotlin.String? = null
        /**
         * Configure export settings to deliver disk images created from your image build, using a file format that is compatible with your VMs in that Region.
         */
        public var s3ExportConfiguration: aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Distribution) : this() {
            this.amiDistributionConfiguration = x.amiDistributionConfiguration
            this.containerDistributionConfiguration = x.containerDistributionConfiguration
            this.fastLaunchConfigurations = x.fastLaunchConfigurations
            this.launchTemplateConfigurations = x.launchTemplateConfigurations
            this.licenseConfigurationArns = x.licenseConfigurationArns
            this.region = x.region
            this.s3ExportConfiguration = x.s3ExportConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Distribution = Distribution(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration] inside the given [block]
         */
        public fun amiDistributionConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration.Builder.() -> kotlin.Unit) {
            this.amiDistributionConfiguration = aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ContainerDistributionConfiguration] inside the given [block]
         */
        public fun containerDistributionConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ContainerDistributionConfiguration.Builder.() -> kotlin.Unit) {
            this.containerDistributionConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ContainerDistributionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration] inside the given [block]
         */
        public fun s3ExportConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration.Builder.() -> kotlin.Unit) {
            this.s3ExportConfiguration = aws.sdk.kotlin.services.imagebuilder.model.S3ExportConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (region == null) region = ""
            return this
        }
    }
}
