// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWorkflowRequest private constructor(builder: Builder) {
    /**
     * Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.
     */
    public val changeDescription: kotlin.String? = builder.changeDescription
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Contains the UTF-8 encoded YAML document content for the workflow. Alternatively, you can specify the `uri` of a YAML document file stored in Amazon S3. However, you cannot specify both properties.
     */
    public val data: kotlin.String? = builder.data
    /**
     * Describes the workflow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the KMS key that is used to encrypt this workflow resource.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the workflow to create.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The semantic version of this workflow resource. The semantic version syntax adheres to the following rules.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * Tags that apply to the workflow resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The phase in the image build process for which the workflow resource is responsible.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = builder.type
    /**
     * The `uri` of a YAML component document file. This must be an S3 URL (`s3://bucket/key`), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.
     *
     * Alternatively, you can specify the YAML document inline, using the component `data` property. You cannot specify both properties.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkflowRequest(")
        append("changeDescription=$changeDescription,")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("type=$type,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeDescription?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkflowRequest

        if (changeDescription != other.changeDescription) return false
        if (clientToken != other.clientToken) return false
        if (data != other.data) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.
         */
        public var changeDescription: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Contains the UTF-8 encoded YAML document content for the workflow. Alternatively, you can specify the `uri` of a YAML document file stored in Amazon S3. However, you cannot specify both properties.
         */
        public var data: kotlin.String? = null
        /**
         * Describes the workflow.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the KMS key that is used to encrypt this workflow resource.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the workflow to create.
         */
        public var name: kotlin.String? = null
        /**
         * The semantic version of this workflow resource. The semantic version syntax adheres to the following rules.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * Tags that apply to the workflow resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The phase in the image build process for which the workflow resource is responsible.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.WorkflowType? = null
        /**
         * The `uri` of a YAML component document file. This must be an S3 URL (`s3://bucket/key`), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.
         *
         * Alternatively, you can specify the YAML document inline, using the component `data` property. You cannot specify both properties.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowRequest) : this() {
            this.changeDescription = x.changeDescription
            this.clientToken = x.clientToken
            this.data = x.data
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.type = x.type
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateWorkflowRequest = CreateWorkflowRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
