// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateImageRecipeRequest private constructor(builder: Builder) {
    /**
     * Specify additional settings and launch scripts for your build instances.
     */
    public val additionalInstanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration? = builder.additionalInstanceConfiguration
    /**
     * The block device mappings of the image recipe.
     */
    public val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The components included in the image recipe.
     */
    public val components: List<ComponentConfiguration>? = builder.components
    /**
     * The description of the image recipe.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the image recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: `arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x`. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.
     */
    public val parentImage: kotlin.String? = builder.parentImage
    /**
     * The semantic version of the image recipe. This version follows the semantic version syntax.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * The tags of the image recipe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The working directory used during build and test workflows.
     */
    public val workingDirectory: kotlin.String? = builder.workingDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageRecipeRequest(")
        append("additionalInstanceConfiguration=$additionalInstanceConfiguration,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("description=$description,")
        append("name=$name,")
        append("parentImage=$parentImage,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("workingDirectory=$workingDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInstanceConfiguration?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateImageRecipeRequest

        if (additionalInstanceConfiguration != other.additionalInstanceConfiguration) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (parentImage != other.parentImage) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify additional settings and launch scripts for your build instances.
         */
        public var additionalInstanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration? = null
        /**
         * The block device mappings of the image recipe.
         */
        public var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The components included in the image recipe.
         */
        public var components: List<ComponentConfiguration>? = null
        /**
         * The description of the image recipe.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the image recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: `arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x`. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.
         */
        public var parentImage: kotlin.String? = null
        /**
         * The semantic version of the image recipe. This version follows the semantic version syntax.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * The tags of the image recipe.
         */
        public var tags: Map<String, String>? = null
        /**
         * The working directory used during build and test workflows.
         */
        public var workingDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest) : this() {
            this.additionalInstanceConfiguration = x.additionalInstanceConfiguration
            this.blockDeviceMappings = x.blockDeviceMappings
            this.clientToken = x.clientToken
            this.components = x.components
            this.description = x.description
            this.name = x.name
            this.parentImage = x.parentImage
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest = CreateImageRecipeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration] inside the given [block]
         */
        public fun additionalInstanceConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.additionalInstanceConfiguration = aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
